-- MySQL dump 10.13  Distrib 8.0.22, for Win64 (x86_64)
--
-- Host: localhost    Database: bdcofasaproduccion
-- ------------------------------------------------------
-- Server version	8.0.22

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actividades`
--

DROP TABLE IF EXISTS `actividades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `actividades` (
  `id_actividad` int NOT NULL AUTO_INCREMENT,
  `codigo` varchar(10) DEFAULT NULL,
  `descripcion` varchar(100) DEFAULT NULL,
  `status` varchar(20) DEFAULT 'Activa',
  `fecharegistro` datetime DEFAULT CURRENT_TIMESTAMP,
  `id_usuario` int DEFAULT '0',
  `es_productiva` int DEFAULT '0',
  PRIMARY KEY (`id_actividad`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actividades`
--

LOCK TABLES `actividades` WRITE;
/*!40000 ALTER TABLE `actividades` DISABLE KEYS */;
INSERT INTO `actividades` VALUES (21,'00001','nueva actividad','Activa','2021-02-08 17:13:37',33,0),(22,'00002','Acondicionar','Activa','2021-02-15 18:27:37',33,0),(23,'00003','Limpieza','Activa','2021-02-15 18:27:55',33,0),(24,'00004','Limpieza Profunda','Activa','2021-02-15 18:28:18',33,0),(25,'00005','Parada','Activa','2021-02-15 18:28:48',33,0),(26,'00006','Documentar','Activa','2021-02-15 18:29:58',33,0),(27,'00007','Mezcla','Activa','2021-03-10 13:58:07',33,1);
/*!40000 ALTER TABLE `actividades` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cargos`
--

DROP TABLE IF EXISTS `cargos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cargos` (
  `id_cargo` int NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(45) DEFAULT NULL,
  `codigo_nomina` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id_cargo`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cargos`
--

LOCK TABLES `cargos` WRITE;
/*!40000 ALTER TABLE `cargos` DISABLE KEYS */;
INSERT INTO `cargos` VALUES (5,'Operador',NULL),(6,'Ayudante',NULL);
/*!40000 ALTER TABLE `cargos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clientes`
--

DROP TABLE IF EXISTS `clientes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `clientes` (
  `id_cliente` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(45) NOT NULL,
  `direccion` varchar(100) DEFAULT NULL,
  `telefono` varchar(45) DEFAULT NULL,
  `rif` varchar(45) DEFAULT NULL,
  `codigo` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id_cliente`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clientes`
--

LOCK TABLES `clientes` WRITE;
/*!40000 ALTER TABLE `clientes` DISABLE KEYS */;
/*!40000 ALTER TABLE `clientes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `departamento`
--

DROP TABLE IF EXISTS `departamento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `departamento` (
  `id_dpto` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(45) NOT NULL,
  `observaciones` varchar(100) DEFAULT NULL,
  `principal` tinyint DEFAULT NULL,
  `tipo_de_costo` varchar(30) DEFAULT 'general',
  `comision_dolar` decimal(11,2) DEFAULT '0.00',
  `comision_bs` decimal(11,2) DEFAULT '0.00',
  PRIMARY KEY (`id_dpto`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `departamento`
--

LOCK TABLES `departamento` WRITE;
/*!40000 ALTER TABLE `departamento` DISABLE KEYS */;
INSERT INTO `departamento` VALUES (17,'area test 1',NULL,NULL,'general',0.00,0.00),(18,'Mezcla',NULL,NULL,'general',0.00,0.00),(19,'Compresion',NULL,NULL,'general',0.00,0.00),(20,'Recubrimiento',NULL,NULL,'general',0.00,0.00),(21,'Bisteado',NULL,NULL,'general',0.00,0.00),(22,'Estuche Solido',NULL,NULL,'general',0.00,0.00),(23,'Arreglos de Ampollas',NULL,NULL,'general',0.00,0.00),(24,'Mezcla de Liquidos Esteriles',NULL,NULL,'general',0.00,0.00),(25,'LLenado de Liquidos Esteriles',NULL,NULL,'general',0.00,0.00),(26,'Revisadora automatica',NULL,NULL,'general',0.00,0.00),(27,'Codificado de Estuche',NULL,NULL,'general',0.00,0.00),(28,'Encunado',NULL,NULL,'general',0.00,0.00),(29,'Estuchado',NULL,NULL,'general',0.00,0.00),(30,'Mezcla de Liquidos no esteriles',NULL,NULL,'general',0.00,0.00),(31,'Llenado de liquidos no esteriles',NULL,NULL,'general',0.00,0.00),(32,'Empaque de liquido no esteriles',NULL,NULL,'general',0.00,0.00),(33,'Mescla de Semi solido',NULL,NULL,'general',0.00,0.00),(34,'Llenado de Semi Solido',NULL,NULL,'general',0.00,0.00),(35,'Codificacion y Estuche',NULL,NULL,'general',0.00,0.00);
/*!40000 ALTER TABLE `departamento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `departamento_01`
--

DROP TABLE IF EXISTS `departamento_01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `departamento_01` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_dpto` int NOT NULL,
  `id_maquina` int NOT NULL,
  `especificaciontecnica` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`,`id_dpto`),
  KEY `id_dpto_maquina_idx` (`id_maquina`),
  KEY `id_dpto_dpto01_idx` (`id_dpto`),
  CONSTRAINT `id_dpto_dpto01` FOREIGN KEY (`id_dpto`) REFERENCES `departamento` (`id_dpto`) ON DELETE CASCADE,
  CONSTRAINT `id_dpto_maquina` FOREIGN KEY (`id_maquina`) REFERENCES `maquinas` (`id_maquina`) ON DELETE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=419 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `departamento_01`
--

LOCK TABLES `departamento_01` WRITE;
/*!40000 ALTER TABLE `departamento_01` DISABLE KEYS */;
INSERT INTO `departamento_01` VALUES (418,33,112,NULL);
/*!40000 ALTER TABLE `departamento_01` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `departamento_02`
--

DROP TABLE IF EXISTS `departamento_02`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `departamento_02` (
  `id_dpto` int NOT NULL,
  `id_actividad` int NOT NULL,
  PRIMARY KEY (`id_dpto`,`id_actividad`),
  CONSTRAINT `fkactividad-dpto` FOREIGN KEY (`id_dpto`) REFERENCES `departamento` (`id_dpto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `departamento_02`
--

LOCK TABLES `departamento_02` WRITE;
/*!40000 ALTER TABLE `departamento_02` DISABLE KEYS */;
INSERT INTO `departamento_02` VALUES (17,21),(18,22),(18,23),(18,24),(18,25),(18,26),(18,27),(33,22);
/*!40000 ALTER TABLE `departamento_02` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `etapas`
--

DROP TABLE IF EXISTS `etapas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `etapas` (
  `id_etapa` int NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_etapa`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `etapas`
--

LOCK TABLES `etapas` WRITE;
/*!40000 ALTER TABLE `etapas` DISABLE KEYS */;
INSERT INTO `etapas` VALUES (1,'Mezcla'),(2,'Compresion'),(3,'Recubrimiento'),(4,'Bisteado'),(5,'Estuche Solido'),(6,'Arreglos de Ampollas'),(7,'Mezcla de Liquidos Esteriles'),(8,'LLenado de Liquidos Esteriles'),(9,'Revisadora automatica'),(10,'Codificado de Estuche'),(11,'Encunado'),(12,'Estuchado'),(13,'Mezcla de Liquidos no esteriles'),(14,'Llenado de liquidos no esteriles'),(15,'Empaque de liquido no esteriles'),(16,'Mescla de Semi solido'),(17,'Llenado de Semi Solido'),(18,'Codificacion y Estuche');
/*!40000 ALTER TABLE `etapas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `formula_01`
--

DROP TABLE IF EXISTS `formula_01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `formula_01` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_formula` int NOT NULL,
  `id_materiaprima` int NOT NULL,
  `porcentaje` decimal(11,2) DEFAULT '0.00',
  PRIMARY KEY (`id`,`id_formula`)
) ENGINE=InnoDB AUTO_INCREMENT=249 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Materia Prima Asociada a cada Formula con su respectivo % de aacuerdo a la cantidad de plastico que se utilizara en la fabricacion ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `formula_01`
--

LOCK TABLES `formula_01` WRITE;
/*!40000 ALTER TABLE `formula_01` DISABLE KEYS */;
INSERT INTO `formula_01` VALUES (248,25,64,0.00);
/*!40000 ALTER TABLE `formula_01` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `formulas`
--

DROP TABLE IF EXISTS `formulas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `formulas` (
  `id_formula` int NOT NULL AUTO_INCREMENT,
  `codigo` varchar(15) DEFAULT NULL,
  `descripcion` varchar(45) DEFAULT NULL,
  `notas` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id_formula`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `formulas`
--

LOCK TABLES `formulas` WRITE;
/*!40000 ALTER TABLE `formulas` DISABLE KEYS */;
INSERT INTO `formulas` VALUES (24,'F000X','FORMULA DE PRUEBA',''),(25,'F-0002','formula del clorace','');
/*!40000 ALTER TABLE `formulas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `grupos`
--

DROP TABLE IF EXISTS `grupos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `grupos` (
  `id_grupo` int NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(45) DEFAULT NULL,
  `notas` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_grupo`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `grupos`
--

LOCK TABLES `grupos` WRITE;
/*!40000 ALTER TABLE `grupos` DISABLE KEYS */;
INSERT INTO `grupos` VALUES (1,'GRUPO A',NULL),(2,'GRUPO B',NULL),(3,'Grupo Impresion',NULL),(4,'SELLADORAS G.N ',NULL),(5,'EXTRUSION GALPÓN INDUSTRIAL',NULL),(6,'EXTRUSION GALPON NUEVO ',NULL),(7,'SELLADO GALPON IND ',NULL);
/*!40000 ALTER TABLE `grupos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `grupos_01`
--

DROP TABLE IF EXISTS `grupos_01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `grupos_01` (
  `id_grupo` int NOT NULL,
  `id_trabajador` int NOT NULL,
  `rol` varchar(45) DEFAULT 'Ayudante',
  PRIMARY KEY (`id_grupo`,`id_trabajador`),
  CONSTRAINT `fkgrupos` FOREIGN KEY (`id_grupo`) REFERENCES `grupos` (`id_grupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `grupos_01`
--

LOCK TABLES `grupos_01` WRITE;
/*!40000 ALTER TABLE `grupos_01` DISABLE KEYS */;
INSERT INTO `grupos_01` VALUES (7,921,'Ayudante');
/*!40000 ALTER TABLE `grupos_01` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `herramientas`
--

DROP TABLE IF EXISTS `herramientas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `herramientas` (
  `id_herramienta` int NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) DEFAULT NULL,
  `descripcion` varchar(45) DEFAULT NULL,
  `ubicacion` varchar(45) DEFAULT NULL,
  `referencia` varchar(45) DEFAULT NULL,
  `cantidad` decimal(11,2) DEFAULT '0.00',
  `costo` decimal(11,2) DEFAULT '0.00',
  PRIMARY KEY (`id_herramienta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `herramientas`
--

LOCK TABLES `herramientas` WRITE;
/*!40000 ALTER TABLE `herramientas` DISABLE KEYS */;
/*!40000 ALTER TABLE `herramientas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `insumos`
--

DROP TABLE IF EXISTS `insumos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `insumos` (
  `id_insumo` int NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) DEFAULT NULL,
  `descripcion` varchar(45) DEFAULT NULL,
  `referencia` varchar(45) DEFAULT NULL,
  `unidad` varchar(20) DEFAULT NULL,
  `costo` decimal(11,2) DEFAULT '0.00',
  PRIMARY KEY (`id_insumo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `insumos`
--

LOCK TABLES `insumos` WRITE;
/*!40000 ALTER TABLE `insumos` DISABLE KEYS */;
/*!40000 ALTER TABLE `insumos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `maquinas`
--

DROP TABLE IF EXISTS `maquinas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `maquinas` (
  `id_maquina` int NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) NOT NULL,
  `observaciones` varchar(100) DEFAULT NULL,
  `produccionxhora` double DEFAULT '0',
  `media_produccion` varchar(45) DEFAULT NULL,
  `serial` varchar(45) DEFAULT NULL,
  `fabricante` varchar(45) DEFAULT NULL,
  `paginaweb` varchar(45) DEFAULT NULL,
  `promedio` double DEFAULT '0',
  `status` varchar(20) DEFAULT 'Activa',
  `codigo` varchar(45) DEFAULT NULL,
  `marca` varchar(45) DEFAULT NULL,
  `proveedor` varchar(45) DEFAULT NULL,
  `codigo_del_activo` varchar(20) DEFAULT NULL,
  `fecha_compra` datetime DEFAULT NULL,
  `id_dpto` int DEFAULT NULL,
  `funcionyusos` varchar(500) DEFAULT NULL,
  `imagen` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id_maquina`)
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `maquinas`
--

LOCK TABLES `maquinas` WRITE;
/*!40000 ALTER TABLE `maquinas` DISABLE KEYS */;
INSERT INTO `maquinas` VALUES (112,'MEZCLADORA',NULL,0,NULL,'1234567890124536789','xerox','',0,'Activa','E-00001',NULL,'SU PROVEEDOR','C-999999','2021-03-08 00:00:00',NULL,'FUNCIONES DEL EQUIPO CCCCC','7b7e6c02-395f-4784-9c8d-f151203c14e4.jpeg');
/*!40000 ALTER TABLE `maquinas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `materiaprima`
--

DROP TABLE IF EXISTS `materiaprima`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `materiaprima` (
  `id` int NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) DEFAULT NULL,
  `descripcion` varchar(45) DEFAULT NULL,
  `equivalentes` varchar(200) DEFAULT NULL,
  `Unidad` varchar(45) DEFAULT NULL,
  `costo` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='tabla de materia primas utilizadas en el proceso producivo';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `materiaprima`
--

LOCK TABLES `materiaprima` WRITE;
/*!40000 ALTER TABLE `materiaprima` DISABLE KEYS */;
INSERT INTO `materiaprima` VALUES (64,'ac','ALCOHOL',NULL,'UNIDAD',0.00),(65,'ALCOL','ALCOHOL',NULL,'LITROS',NULL);
/*!40000 ALTER TABLE `materiaprima` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `planificaciones`
--

DROP TABLE IF EXISTS `planificaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `planificaciones` (
  `id_plan` int NOT NULL AUTO_INCREMENT,
  `numerodeorden` varchar(15) NOT NULL,
  `fecharegistro` datetime DEFAULT CURRENT_TIMESTAMP,
  `fechainicial` date DEFAULT NULL,
  `fechafinal` date DEFAULT NULL,
  `id_usuario` int DEFAULT NULL,
  `status` varchar(45) DEFAULT 'Activa',
  `id_dpto` int DEFAULT '0',
  `horas_disponibles` int DEFAULT '0',
  PRIMARY KEY (`id_plan`)
) ENGINE=InnoDB AUTO_INCREMENT=231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='aqui se registran el plan de produccion en un periodo de tiempo';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `planificaciones`
--

LOCK TABLES `planificaciones` WRITE;
/*!40000 ALTER TABLE `planificaciones` DISABLE KEYS */;
INSERT INTO `planificaciones` VALUES (221,'00001','2021-03-11 18:27:10','2021-03-01','2021-03-05',33,'Activa',18,48),(222,'00002','2021-03-11 18:34:57','2021-03-01','2021-03-05',33,'Activa',18,0),(223,'00003','2021-03-11 18:43:53','2021-03-01','2021-03-05',33,'Activa',18,48),(224,'00004','2021-03-11 18:46:36','2021-03-01','2021-03-05',33,'Activa',18,25),(225,'00005','2021-03-11 18:51:07','2021-03-01','2021-03-05',33,'Activa',18,0),(226,'00006','2021-03-11 18:54:56','2021-03-01','2021-03-05',33,'Activa',18,0),(227,'00007','2021-03-11 18:57:18','2021-03-01','2021-03-05',33,'Activa',18,0),(228,'00008','2021-03-11 19:16:39','2021-03-01','2021-03-05',33,'Activa',18,25),(229,'00009','2021-03-11 19:41:30','2021-03-01','2021-03-05',33,'Activa',18,48),(230,'00010','2021-03-11 20:52:42','2021-03-08','2021-03-11',33,'Activa',18,48);
/*!40000 ALTER TABLE `planificaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `planificaciones_01`
--

DROP TABLE IF EXISTS `planificaciones_01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `planificaciones_01` (
  `id_plan` int NOT NULL,
  `id_unico` int NOT NULL,
  `dia` varchar(45) DEFAULT NULL,
  `id_actividad` int DEFAULT '0',
  `hora_inicio` time DEFAULT NULL,
  `hora_final` time DEFAULT NULL,
  `fecha` datetime DEFAULT NULL,
  `nombre_actividad` varchar(200) DEFAULT NULL,
  `nombre_producto` varchar(200) DEFAULT NULL,
  `id_producto` int DEFAULT '0',
  PRIMARY KEY (`id_plan`,`id_unico`),
  CONSTRAINT `fk_plan_01` FOREIGN KEY (`id_plan`) REFERENCES `planificaciones` (`id_plan`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `planificaciones_01`
--

LOCK TABLES `planificaciones_01` WRITE;
/*!40000 ALTER TABLE `planificaciones_01` DISABLE KEYS */;
INSERT INTO `planificaciones_01` VALUES (229,1,'Lunes',23,'07:00:00','08:30:00','2021-03-01 00:00:00','Liempieza','',0),(229,2,'Lunes',27,'08:45:00','09:15:00','2021-03-01 00:00:00','Mezcla','Ketoprofeno Inyectable',11128),(229,3,'Lunes',27,'09:30:00','11:50:00','2021-03-01 00:00:00','Mezcla','BREXIN FORTE',11129),(230,1,'Lunes',23,'07:00:00','08:00:00','2021-03-08 00:00:00','Liempieza','',0),(230,2,'Lunes',27,'08:10:00','09:00:00','2021-03-08 00:00:00','Mezcla','Ketoprofeno Inyectable',11128),(230,3,'Lunes',27,'09:10:00','11:50:00','2021-03-08 00:00:00','Mezcla','Euselin Inyectable',11131);
/*!40000 ALTER TABLE `planificaciones_01` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `planificaciones_02`
--

DROP TABLE IF EXISTS `planificaciones_02`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `planificaciones_02` (
  `id_plan` int NOT NULL,
  `id_unico` int NOT NULL,
  `nro_registro` int NOT NULL DEFAULT '0',
  `id_producto` int DEFAULT '0',
  `id_actividad` int DEFAULT '0',
  `lote` varchar(45) DEFAULT NULL,
  `cantidad` decimal(11,2) DEFAULT '0.00',
  `filtro` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id_plan`,`id_unico`,`nro_registro`),
  CONSTRAINT `fk_plan_02` FOREIGN KEY (`id_plan`, `id_unico`) REFERENCES `planificaciones_01` (`id_plan`, `id_unico`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `planificaciones_02`
--

LOCK TABLES `planificaciones_02` WRITE;
/*!40000 ALTER TABLE `planificaciones_02` DISABLE KEYS */;
INSERT INTO `planificaciones_02` VALUES (230,2,1,11128,27,'001',1500.00,'2-11128-Lunes'),(230,2,2,11128,27,'002',1600.00,'2-11128-Lunes'),(230,3,1,11131,27,'003',1000.00,'3-11131-Lunes'),(230,3,2,11131,27,'004',2000.00,'3-11131-Lunes'),(230,3,3,11131,27,'005',3000.00,'3-11131-Lunes');
/*!40000 ALTER TABLE `planificaciones_02` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `plantillaconsumo`
--

DROP TABLE IF EXISTS `plantillaconsumo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `plantillaconsumo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(45) DEFAULT NULL,
  `observaciones` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `plantillaconsumo`
--

LOCK TABLES `plantillaconsumo` WRITE;
/*!40000 ALTER TABLE `plantillaconsumo` DISABLE KEYS */;
/*!40000 ALTER TABLE `plantillaconsumo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `plantillaconsumo_01`
--

DROP TABLE IF EXISTS `plantillaconsumo_01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `plantillaconsumo_01` (
  `id_plantilla` int NOT NULL,
  `id_materiaprima` varchar(45) NOT NULL,
  `cantidad` decimal(11,2) DEFAULT NULL,
  PRIMARY KEY (`id_plantilla`,`id_materiaprima`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `plantillaconsumo_01`
--

LOCK TABLES `plantillaconsumo_01` WRITE;
/*!40000 ALTER TABLE `plantillaconsumo_01` DISABLE KEYS */;
/*!40000 ALTER TABLE `plantillaconsumo_01` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `produccion_diaria`
--

DROP TABLE IF EXISTS `produccion_diaria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `produccion_diaria` (
  `id_produccion` int NOT NULL AUTO_INCREMENT,
  `fecha` date NOT NULL,
  `id_turno` int NOT NULL DEFAULT '0',
  `id_dpto` int NOT NULL DEFAULT '0',
  `id_supervisor` int DEFAULT '0',
  `fecha_registro` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `cantidadmerma` decimal(11,2) DEFAULT '0.00',
  `Observaciones` varchar(1000) DEFAULT NULL,
  `status` varchar(40) DEFAULT 'Activo',
  `id_usuario` int NOT NULL DEFAULT '0',
  `tabladetallemaquinas` mediumtext,
  `fechacierre` date DEFAULT NULL,
  `id_usuario_cierre` int DEFAULT '0',
  `pasoasaint` int DEFAULT '0',
  `id_grupo` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_produccion`)
) ENGINE=InnoDB AUTO_INCREMENT=309 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `produccion_diaria`
--

LOCK TABLES `produccion_diaria` WRITE;
/*!40000 ALTER TABLE `produccion_diaria` DISABLE KEYS */;
/*!40000 ALTER TABLE `produccion_diaria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `produccion_diaria_01`
--

DROP TABLE IF EXISTS `produccion_diaria_01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `produccion_diaria_01` (
  `id_produccion` int NOT NULL AUTO_INCREMENT,
  `id_maquina` int NOT NULL,
  `id_unico` varchar(45) NOT NULL DEFAULT '1',
  `orden` varchar(10) DEFAULT NULL,
  `operador` int DEFAULT '0',
  `ayudante1` int DEFAULT '0',
  `ayudante2` int DEFAULT '0',
  `cantidad` decimal(11,2) DEFAULT '0.00',
  `nombre_operador` varchar(45) DEFAULT NULL,
  `nombre_ayudante1` varchar(45) DEFAULT NULL,
  `nombre_ayudante2` varchar(45) DEFAULT NULL,
  `descripcion_articulo` varchar(45) DEFAULT NULL,
  `peso` decimal(11,2) DEFAULT '0.00',
  `merma` decimal(11,2) DEFAULT '0.00',
  `kilosentrantes` decimal(11,2) DEFAULT '0.00',
  `horastrabajadas` decimal(11,2) DEFAULT '0.00',
  PRIMARY KEY (`id_produccion`,`id_maquina`,`id_unico`),
  KEY `primario` (`id_produccion`,`id_maquina`),
  CONSTRAINT `fkdetalle` FOREIGN KEY (`id_produccion`) REFERENCES `produccion_diaria` (`id_produccion`)
) ENGINE=InnoDB AUTO_INCREMENT=309 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='	';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `produccion_diaria_01`
--

LOCK TABLES `produccion_diaria_01` WRITE;
/*!40000 ALTER TABLE `produccion_diaria_01` DISABLE KEYS */;
/*!40000 ALTER TABLE `produccion_diaria_01` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `produccion_diaria_02`
--

DROP TABLE IF EXISTS `produccion_diaria_02`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `produccion_diaria_02` (
  `idnew` int NOT NULL AUTO_INCREMENT,
  `id_produccion` int NOT NULL,
  `id_materiaprima` int NOT NULL,
  `cantidad` decimal(11,2) DEFAULT '0.00',
  `fecha_hora` datetime DEFAULT NULL,
  `fecha_horatext` varchar(45) DEFAULT NULL,
  `id_maquina` int DEFAULT '0',
  `filtro` varchar(150) DEFAULT NULL,
  `des_maquina` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`idnew`,`id_produccion`,`id_materiaprima`),
  KEY `fkconsumoturno_idx` (`id_produccion`),
  CONSTRAINT `fkconsumoturno` FOREIGN KEY (`id_produccion`) REFERENCES `produccion_diaria` (`id_produccion`)
) ENGINE=InnoDB AUTO_INCREMENT=2488 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `produccion_diaria_02`
--

LOCK TABLES `produccion_diaria_02` WRITE;
/*!40000 ALTER TABLE `produccion_diaria_02` DISABLE KEYS */;
/*!40000 ALTER TABLE `produccion_diaria_02` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `produccion_diaria_03`
--

DROP TABLE IF EXISTS `produccion_diaria_03`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `produccion_diaria_03` (
  `id_produccion` int NOT NULL,
  `id_maquina` int NOT NULL,
  `id_actividad` int NOT NULL,
  `fecha_hora` varchar(100) DEFAULT NULL,
  `valor` varchar(45) DEFAULT NULL,
  `filtro` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id_produccion`,`id_actividad`,`id_maquina`),
  CONSTRAINT `fk-actividad-prod` FOREIGN KEY (`id_produccion`) REFERENCES `produccion_diaria` (`id_produccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `produccion_diaria_03`
--

LOCK TABLES `produccion_diaria_03` WRITE;
/*!40000 ALTER TABLE `produccion_diaria_03` DISABLE KEYS */;
/*!40000 ALTER TABLE `produccion_diaria_03` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productos`
--

DROP TABLE IF EXISTS `productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `productos` (
  `id_productos` int NOT NULL AUTO_INCREMENT,
  `codigo` varchar(15) DEFAULT NULL,
  `descripcion` varchar(100) NOT NULL,
  `unidad_medida` varchar(15) DEFAULT NULL,
  `peso` decimal(10,4) DEFAULT '0.0000',
  `tipo_producto` int NOT NULL DEFAULT '0',
  `id_formula` int DEFAULT '0',
  `es_subproducto` int NOT NULL DEFAULT '0',
  `comision_dolar` decimal(11,2) DEFAULT NULL,
  `comision_bs` decimal(11,2) DEFAULT NULL,
  `imagen` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id_productos`)
) ENGINE=InnoDB AUTO_INCREMENT=11134 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productos`
--

LOCK TABLES `productos` WRITE;
/*!40000 ALTER TABLE `productos` DISABLE KEYS */;
INSERT INTO `productos` VALUES (11128,'ke-0001','Ketoprofeno Inyectable','LITROS',0.0000,1,24,1,0.00,0.00,''),(11129,'BRX','BREXIN FORTE','UNIDAD',0.0000,4,24,0,0.00,0.00,'76d03d16-943f-4d56-9c7e-6fb8d74a2264.jpg'),(11130,'clo-001','Miovit  Jarabe','UNIDAD',0.0000,3,25,0,0.00,0.00,'891cffc7-8a04-4749-a427-63ab4997427f.jpg'),(11131,'x-000','Euselin Inyectable','UNIDAD',0.0000,1,24,0,0.00,0.00,''),(11132,'c-0009','Miovit Inyectable','UNIDAD',0.0000,1,24,0,0.00,0.00,''),(11133,'c-00007','Miovit Grageas','UNIDAD',0.0000,1,24,0,0.00,0.00,'');
/*!40000 ALTER TABLE `productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productos_01`
--

DROP TABLE IF EXISTS `productos_01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `productos_01` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_producto` int NOT NULL,
  `observacion` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`,`id_producto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='aqui se guardan los equivalentes de cada materia prima';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productos_01`
--

LOCK TABLES `productos_01` WRITE;
/*!40000 ALTER TABLE `productos_01` DISABLE KEYS */;
/*!40000 ALTER TABLE `productos_01` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `repuestos`
--

DROP TABLE IF EXISTS `repuestos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `repuestos` (
  `id_repuesto` int NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) DEFAULT NULL,
  `descripcion` varchar(45) DEFAULT NULL,
  `unidad` varchar(20) DEFAULT NULL,
  `referencia` varchar(30) DEFAULT NULL,
  `costo` decimal(11,2) DEFAULT '0.00',
  `usos_frecuentes` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_repuesto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `repuestos`
--

LOCK TABLES `repuestos` WRITE;
/*!40000 ALTER TABLE `repuestos` DISABLE KEYS */;
/*!40000 ALTER TABLE `repuestos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rutas`
--

DROP TABLE IF EXISTS `rutas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `rutas` (
  `id_ruta` int NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_ruta`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rutas`
--

LOCK TABLES `rutas` WRITE;
/*!40000 ALTER TABLE `rutas` DISABLE KEYS */;
INSERT INTO `rutas` VALUES (1,'SOLIDOS'),(2,'SEMI-SOLIDOS'),(3,'LIQUIDOS ESTERILES'),(4,'LIQUIDOS NO ESTERILES');
/*!40000 ALTER TABLE `rutas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rutas_01`
--

DROP TABLE IF EXISTS `rutas_01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `rutas_01` (
  `id_ruta` int NOT NULL,
  `id_etapa` int NOT NULL,
  `orden` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_ruta`,`id_etapa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rutas_01`
--

LOCK TABLES `rutas_01` WRITE;
/*!40000 ALTER TABLE `rutas_01` DISABLE KEYS */;
INSERT INTO `rutas_01` VALUES (1,1,0),(1,2,1),(1,3,2),(1,4,3),(1,5,4),(2,16,0),(2,17,1),(2,18,2),(3,6,0),(3,7,1),(3,8,2),(3,9,3),(3,10,4),(3,11,5),(3,12,6),(4,13,0),(4,14,1),(4,15,2);
/*!40000 ALTER TABLE `rutas_01` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `session_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `expires` int unsigned NOT NULL,
  `data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
INSERT INTO `sessions` VALUES ('Nv5S378c98X8_IpL6iS__vmH5pht-6Gy',1615596765,'{\"cookie\":{\"originalMaxAge\":null,\"expires\":null,\"httpOnly\":true,\"path\":\"/\"},\"flash\":{},\"passport\":{\"user\":33}}'),('d1aVTs_vNqG-hDLmQuO2bKe0LsuFW5Hc',1615641258,'{\"cookie\":{\"originalMaxAge\":null,\"expires\":null,\"httpOnly\":true,\"path\":\"/\"},\"flash\":{},\"passport\":{\"user\":33}}'),('dN2jV5z5QMrsoznDXL1ilqdCv3D-CbkY',1615661707,'{\"cookie\":{\"originalMaxAge\":null,\"expires\":null,\"httpOnly\":true,\"path\":\"/\"},\"flash\":{},\"passport\":{\"user\":33}}');
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tecnicos`
--

DROP TABLE IF EXISTS `tecnicos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tecnicos` (
  `id_tecnico` int NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) DEFAULT NULL,
  `nombre` varchar(45) DEFAULT NULL,
  `cargouoficio` varchar(45) DEFAULT NULL,
  `valorhora` decimal(11,2) DEFAULT '0.00',
  `telefonos` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_tecnico`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tecnicos`
--

LOCK TABLES `tecnicos` WRITE;
/*!40000 ALTER TABLE `tecnicos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tecnicos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tipoproducto`
--

DROP TABLE IF EXISTS `tipoproducto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tipoproducto` (
  `id_tipo` int NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(45) DEFAULT NULL,
  `id_ruta` varchar(45) DEFAULT NULL,
  `unidad_presentacion` varchar(45) DEFAULT NULL,
  `tipo` int DEFAULT '0',
  PRIMARY KEY (`id_tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='tipo = 0 --> solidos y semi-solidos\ntipo = 1 ---> liquidos esteriles y no estriles\n';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tipoproducto`
--

LOCK TABLES `tipoproducto` WRITE;
/*!40000 ALTER TABLE `tipoproducto` DISABLE KEYS */;
INSERT INTO `tipoproducto` VALUES (1,'SOLIDOS','1','miligramos(mg)',0),(2,'LIQUIDOS ESTERILES','3','mililitros',1),(3,'LIQUIDOS NO ESTERILES','4','mililitros',1),(4,'SEMI SOLIDOS.','1','miligramos(mg)',0);
/*!40000 ALTER TABLE `tipoproducto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trabajadores`
--

DROP TABLE IF EXISTS `trabajadores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `trabajadores` (
  `id_trabajador` int NOT NULL AUTO_INCREMENT,
  `Nombre` varchar(45) NOT NULL,
  `Apellido` varchar(45) NOT NULL,
  `cargo` varchar(45) DEFAULT NULL,
  `operador` tinyint NOT NULL DEFAULT '0',
  `supervisor` tinyint NOT NULL DEFAULT '0',
  `status` varchar(20) DEFAULT 'Activo',
  `cedula` varchar(15) DEFAULT NULL,
  `id_cargo` int DEFAULT '1',
  `fecha_registro` datetime DEFAULT CURRENT_TIMESTAMP,
  `fecha_ingreso` datetime DEFAULT NULL,
  `codigo_nomina` varchar(20) DEFAULT NULL,
  `foto` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id_trabajador`)
) ENGINE=InnoDB AUTO_INCREMENT=1028 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trabajadores`
--

LOCK TABLES `trabajadores` WRITE;
/*!40000 ALTER TABLE `trabajadores` DISABLE KEYS */;
INSERT INTO `trabajadores` VALUES (1027,'LUIS R','RODRIGUEZ',NULL,0,0,'Activo','11524896',5,'2021-03-09 09:56:53','2021-03-09 00:00:00','c-0009','5979d999-1ec9-46e1-b214-f0567579dbf0.jpeg');
/*!40000 ALTER TABLE `trabajadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `turnos`
--

DROP TABLE IF EXISTS `turnos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `turnos` (
  `id_turnos` int NOT NULL AUTO_INCREMENT,
  `descripcion1` varchar(45) NOT NULL,
  `descripcion2` varchar(45) DEFAULT NULL,
  `horarios` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_turnos`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `turnos`
--

LOCK TABLES `turnos` WRITE;
/*!40000 ALTER TABLE `turnos` DISABLE KEYS */;
INSERT INTO `turnos` VALUES (1,'TURNO A','DIURNO','07AM-03PM'),(2,'TURNO B','MIXTO','03PM-10PM'),(3,'TURNO C','NOCTURNO','10PM-05AM'),(4,'TURNO D','ESPECIAL','07AM-07 PM'),(5,'TURNO E','ESPECIAL','07PM-07 AM'),(6,'COMPLEMENTO','ESPACIAL ','07PM-10PM');
/*!40000 ALTER TABLE `turnos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `usuarios`
--

DROP TABLE IF EXISTS `usuarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `usuarios` (
  `id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(45) NOT NULL,
  `password` varchar(500) NOT NULL,
  `fullname` varchar(100) NOT NULL,
  `email` varchar(45) NOT NULL,
  `rol` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Tabla de Usuarios\nrol = 0       --> Supervisor\nrol = 1       --> Operador\nrol = 99 = -- >Administrador';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `usuarios`
--

LOCK TABLES `usuarios` WRITE;
/*!40000 ALTER TABLE `usuarios` DISABLE KEYS */;
INSERT INTO `usuarios` VALUES (33,'nelson','$2a$10$3zZ9DisZ7DgSRu4b7rT3.O0mOwp1plyobFRb.BQH7yftAPEaXnwES','Nelson Fonseca','nflfonseca@gmail.com',0),(34,'pgomez','$2a$10$vLhMstEjVBqRP9HFFd9JQeRVx7mz4mOHJmJr1m71dQ367C.aOdZrO','Pedro Gomez','pedroagomez@gmail.com',0);
/*!40000 ALTER TABLE `usuarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'bdcofasaproduccion'
--
/*!50003 DROP FUNCTION IF EXISTS `getFakeId` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `getFakeId`() RETURNS int
    DETERMINISTIC
begin
return if(@fakeId, @fakeId:=@fakeId+1, @fakeId:=0);
end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `produccionAddOrEdit` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` PROCEDURE `produccionAddOrEdit`(
IN _produccion_id INT,
IN _fecha DATETIME,
IN _id_turno INT,
IN _id_operador INT,
IN _status VARCHAR(15),
IN _id_maquina INT,
IN _id_cliente INT,
IN _id_producto INT,
IN _cantidad DOUBLE,
IN _id_supervisor INT,
IN _merma DOUBLE,
IN _observaciones VARCHAR(500),
IN _notascalidad VARCHAR(500),
IN _id_usuario INT
)
BEGIN
IF  _produccion_id = 0 THEN
INSERT INTO produccion_diaria(fecha,id_turno,id_operador,id_maquina,id_cliente,id_producto,cantidad,id_usuario, id_supervisor, cantidadmerma, observaciones, notascalidad)
VALUES (_fecha,_id_turno,_id_operador,_id_maquina,_id_cliente,_id_producto,_cantidad,_id_usuario,_id_supervisor,_merma,_observaciones,_notascalidad);
SET _produccion_id = last_insert_id();
ELSE
    UPDATE produccion_diaria
    SET
       fecha = _fecha,
       id_turno = _id_turno,
       id_operador = _id_operador,
       id_maquina = _id_maquina,
       id_cliente = _id_cliente,
       id_producto = _id_producto,
       cantidad = _cantidad,
       id_usuario = _id_usuario,
       id_supervisor = _id_supervisor,
       cantidadmerma = _merma,
       observaciones = _observaciones,
       notascalidad = _notascalidad
    WHERE id_produccion = _produccion_id;
END IF;
SELECT _produccion_id AS 'produccion_id';
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-03-12 16:23:07
