const mysql = require('mysql');
const {promisify} = require('util');
const { database } = require('./keys');


// creacion de la conexion de la base de datos utilizando promesas
const pool =  mysql.createPool(database);

pool.getConnection((err,connection) => {

  if (err) {
      if (err.code === 'PROTOCOL_CONNECTION_LOST') {
          console.error ('CONECCION CON LA BASE DE DATOS FUE CERRADA');
      }

      if (err.code === 'ER_CON_COUNT_ERROR') {
        console.error ('LA BASE DE DATOS TIENE MUCHAS CONEXIONES ABIERTAS');
      }

      if (err.code === 'ECONNREFUSED') {
        console.error ('CONECCION CON LA BASE DE DATOS FUE NEGADA O RECHAZADA');
      }
  }
  if (connection) connection.release();
  console.log('Base de Datos Conectada');
  return;
});
// fin de la conexion de la base de datos


// Promisyfy Pool Query
pool.query = promisify(pool.query);

// se retorna el pool de conexion definido

module.exports = pool;
