const bcrypt = require('bcryptjs');

const pool = require('../database');
const Rollbar = require("rollbar");

var rollbar = new Rollbar({
    accessToken: 'ce7c7a535a6041c59033de55e96cd691',
    captureUncaught: true,
    captureUnhandledRejections: true
  });
  
 const { v4: uuidv4 } = require('uuid');



var config = {  
    server: 'DESKTOP-ATVTTDJ\SQLEXPRESS',  //update me
    authentication: {
        type: 'default',
        options: {
            userName: 'sa', //update me
            password: '123456'  //update me
        }
    }
};

const helpers = {};


helpers.encryptPassword = async (password) => {
 const salt = await bcrypt.genSalt(10);
 const hash = await bcrypt.hash(password,salt);
 return hash; 
};

//********************************************************* */
helpers.matchPassword = async (password, savedPassword) => {
   
    try {
       return await bcrypt.compare (password,savedPassword);     
    } catch (e) {
        manejo_de_errorHelper(e);
    }

};
//************************************************************** */
helpers.PadL = (cadena,cantidad) => {
    var valor = cadena;
    return  valor.padStart(cantidad,'0')   
}
//************************************************************** */
helpers.trabajador = async (id) => {
    try {
        const el_id = id;
        const sql = "SELECT concat_ws(' ', nombre, apellido ) as Trabajador  FROM trabajadores   WHERE   id_trabajador = ?";
        const registro =  await pool.query(sql,[el_id]);
         if (registro.length > 0) {
            return await registro[0].Trabajador;
         }
         else {
             return await '';
         }
    } catch (e) {
        manejo_de_errorHelper(e);
    }    

};
//******************************************** */
helpers.des_formula = async (id) => {
    try {
        const el_id = id;
        const sql = "SELECT  descripcion FROM formulas Where  id_formula = ?";
        const registro =  await pool.query(sql,[el_id]);
         if (registro.length > 0) {
            return await registro[0].descripcion;
         }
         else {
             return await ' ';
         }
    } catch (e) {
        manejo_de_errorHelper(e);
    }    

};
//******************************************************* */
helpers.des_tipo_producto = async (id) => {
    try {
        const el_id = id;
        const sql = "SELECT  descripcion FROM tipoproducto Where  id_tipo = ?";
        const registro =  await pool.query(sql,[el_id]);
         if (registro.length > 0) {
            return await registro[0].descripcion;
         }
         else {
             return await ' ';
         }
    } catch (e) {
        manejo_de_errorHelper(e);
    }    

};

//******************************************************* */

helpers.des_medida =  (medida) => {
   var medida1 = '' + medida ;
   if (medida1.trim().length == 0) {
       return 'mm'
   } else {
       return medida
   }
};


//********************************* */

helpers.productoasociado = async (orden) => {
    try {
        const la_orden = orden;
        const sql = "SELECT productos.descripcion  FROM planificaciones, productos Where productos.id_productos = planificaciones.id_producto and  planificaciones.numerodeorden =? ";
        const registro =  await pool.query(sql,[la_orden]);
         if (registro.length > 0) {
            return await registro[0].descripcion;
         }
         else {
             return await '';
         }
    } catch (e) {
        manejo_de_errorHelper(e);
    }    

};

//************************************************************************* */
helpers.validar_decimal = (numero)  => {
    var valor= numero;
    var numero = 0;
    valor = parseFloat( '0' + valor);
    if ( isNaN(valor)  ) {
        numero = 0;
    }else {
        numero = valor;
    }
    return numero;
};
//************************************************************************* */
helpers.validar_entero = (numero)  => {
    var valor= numero;
    var numero = 0;
    valor = parseInt( '0' + valor);
    if ( isNaN(valor)  ) {
        numero = 0;
    }else {
        numero = valor;
    }
    return numero;
};

//************************************************************************* */
helpers.InsertDetalle_Plan_02 = async (id,tabla_lotes) => {   
    try {         
        const myArray = JSON.parse(tabla_lotes);
        var id_plan = helpers.validar_entero(id) ;
        var id_unico , id_producto, id_actividad, filtro, lote, cantidad, nro_registro;
        for (var i = 0; i < myArray.length; i++) {           
            id_unico =  helpers.validar_entero(myArray[i].id_unico) ;
            id_producto = helpers.validar_entero(myArray[i].id_producto);
            id_actividad = helpers.validar_entero(myArray[i].id_actividad);
            filtro = myArray[i].filtro;
            lote = myArray[i].lote;
            cantidad = helpers.validar_decimal( myArray[i].cantidad);
            nro_registro = helpers.validar_entero(myArray[i].nro_registro);

            const sql = "INSERT INTO planificaciones_02  (id_plan, id_unico, nro_registro, id_producto, id_actividad, lote, cantidad, filtro) VALUES (?,?,?,?,?,?,?,?) "
            const result = await pool.query(sql,[id_plan, id_unico, nro_registro, id_producto, id_actividad, lote , cantidad, filtro]);
        }

    } catch (e) {
        manejo_de_errorHelper(e);
    }    
   return await 'exito';
}  //fin
//*************************************************************************** */
helpers.InsertDetalle_Plan = async (id,tabla, tabla_lotes) => {   
    try {         
        const myArray = JSON.parse(tabla);
        var id_plan = helpers.validar_entero(id) ;
        var id_unico , fecha, id_producto, id_actividad, el_dia, nombre_producto, nombre_actividad, h_inicio, h_final;
        for (var i = 0; i < myArray.length; i++) {
            
            fecha = myArray[i].fecha;
            id_unico =  helpers.validar_entero(myArray[i].id_unico) ;
            id_producto = helpers.validar_entero(myArray[i].id_producto);
            id_actividad = helpers.validar_entero(myArray[i].id_actividad);
            el_dia = myArray[i].dia;

            nombre_actividad = myArray[i].nombre_actividad;
            nombre_producto = myArray[i].nombre_producto;


            h_inicio = myArray[i].hora_inicio;
            h_final = myArray[i].hora_final;

            const sql = "INSERT INTO planificaciones_01  (id_plan,id_unico, id_actividad, fecha, dia, nombre_actividad, nombre_producto, hora_inicio, hora_final, id_producto) VALUES (?,?,?,?,?,?,?,?,?,?) "
            const result = await pool.query(sql,[id_plan,id_unico, id_actividad, fecha, el_dia,nombre_actividad,nombre_producto,h_inicio, h_final, id_producto]);

        }

        const exito2 = await helpers.InsertDetalle_Plan_02 (id_plan,tabla_lotes)

    } catch (e) {
        manejo_de_errorHelper(e);
    }    
   return await 'exito';
}
//*********************************************************** */
helpers.EliminarRegistrosDe_planificaciones_02= async (arrayElim, Id_registro) => {
    var id_plan, id_unico, nro_registro;
    try {
        id_plan = helpers.validar_entero(Id_registro)
       for ( var i = 0 ; i < arrayElim.length; i++){
            id_unico = helpers.validar_entero(arrayElim[i].id_unicoD);
            nro_registro = helpers.validar_entero(arrayElim[i].nro_registroD)
            const sql = "DELETE FROM planificaciones_02 Where id_plan = ? and id_unico = ? and nro_registro = ?  "
            const result = await pool.query(sql,[id_plan, id_unico, nro_registro]);     
          }
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};


//*************************************************************** */
helpers.EliminarRegistrosDe_planificaciones_01 = async (arrayElim, Id_registro) => {
    var id_plan, id_unico;
    try {
        id_plan = helpers.validar_entero(Id_registro)
       for ( var i = 0 ; i < arrayElim.length; i++){
            id_unico = helpers.validar_entero(arrayElim[i].id_unicoD);
            const sql = "DELETE FROM planificaciones_01 Where id_plan = ? and id_unico = ? "
            const result = await pool.query(sql,[id_plan, id_unico]);     
          }

    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};

//******************************************************/
helpers.Update_detalles_Planificaciones = async (tabla_actividades,id_maestro,tabladeeliminados,tabla_lotes, tabla_lotes_deleted) => {
    try {
        const myArray = JSON.parse(tabla_actividades); 
        const ArrayElim = JSON.parse(tabladeeliminados); 
        
        const Array_lot_elim = JSON.parse(tabla_lotes_deleted); 

        var id_unico , fecha, id_producto, id_actividad, el_dia, nombre_producto, nombre_actividad, h_inicio, h_final, id_plan;

        id_plan = helpers.validar_entero(id_maestro);

        
        var exiElim = await helpers.EliminarRegistrosDe_planificaciones_01 (ArrayElim, id_plan);
       for ( var i = 0 ; i < myArray.length; i++){
            fecha = myArray[i].fecha;
            id_unico =  helpers.validar_entero(myArray[i].id_unico) ;
            id_producto = helpers.validar_entero(myArray[i].id_producto);
            id_actividad = helpers.validar_entero(myArray[i].id_actividad);
            el_dia = myArray[i].dia;
            nombre_actividad = myArray[i].nombre_actividad;
            nombre_producto = myArray[i].nombre_producto;
            h_inicio = myArray[i].hora_inicio;
            h_final = myArray[i].hora_final;

            const sql = "UPDATE planificaciones_01 SET fecha =?, dia = ?, id_actividad = ? , nombre_actividad = ?,  id_producto = ? , nombre_producto = ?, hora_inicio = ? , Hora_final = ?  Where  id_plan = ? and id_unico = ?"
            const result = await pool.query(sql,[fecha,el_dia,id_actividad,nombre_actividad, id_producto,nombre_producto,h_inicio,h_final,id_plan, id_unico ]);     
            if (result.affectedRows <= 0 ) {
                const sql2 = "INSERT INTO planificaciones_01  (id_plan,id_unico, id_actividad, fecha, dia, nombre_actividad, nombre_producto, hora_inicio, hora_final, id_producto) VALUES (?,?,?,?,?,?,?,?,?,?) "
                const result2 = await pool.query(sql2,[id_plan,id_unico, id_actividad, fecha, el_dia,nombre_actividad,nombre_producto,h_inicio, h_final, id_producto]);    
            }
          };
          var exiElim_lotes = await helpers.EliminarRegistrosDe_planificaciones_02(Array_lot_elim,id_plan);
          var exit02= await helpers.Update_Detalle_Plan_02(id_plan,tabla_lotes)
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};

//******************************************************** */
helpers.Update_Detalle_Plan_02 = async (id,tabla_lotes) => {   
    try {         
        const myArray = JSON.parse(tabla_lotes);
        var id_plan = helpers.validar_entero(id) ;
        var id_unico , id_producto, id_actividad, filtro, lote, cantidad, nro_registro;
        for (var i = 0; i < myArray.length; i++) {           
            id_unico =  helpers.validar_entero(myArray[i].id_unico) ;
            id_producto = helpers.validar_entero(myArray[i].id_producto);
            id_actividad = helpers.validar_entero(myArray[i].id_actividad);
            filtro = myArray[i].filtro;
            lote = myArray[i].lote;
            cantidad = helpers.validar_decimal( myArray[i].cantidad);
            nro_registro = helpers.validar_entero(myArray[i].nro_registro);

            const sql = "UPDATE planificaciones_02 SET lote = ? , cantidad = ? Where id_plan = ? and  id_unico = ? and nro_registro = ?"
            const result = await pool.query(sql,[lote,cantidad,id_plan,id_unico,nro_registro ]);     
            if (result.affectedRows <= 0 ) {
               const sql2 = "INSERT INTO planificaciones_02  (id_plan, id_unico, nro_registro, id_producto, id_actividad, lote, cantidad, filtro) VALUES (?,?,?,?,?,?,?,?) "
               const result2 = await pool.query(sql2,[id_plan, id_unico, nro_registro, id_producto, id_actividad, lote , cantidad, filtro]);
            }
        }

    } catch (e) {
        manejo_de_errorHelper(e);
    }    
   return await 'exito';
}  //fin

//******************************************************** */
helpers.UdateMateriaPrimaPlan = async (id,tabla) => {
    const myArray = JSON.parse(tabla);  
    try {         
        const sql1 = 'DELETE FROM planificaciones_02 Where id_plan = ?'
        const result1 = await pool.query(sql1,[id]);

        var id_materiaprima = 0 ;
        var cantidad = 0;
        
        for (var i = 0; i < myArray.length; i++) {
            materiaprima =  myArray[i].Id_materiaprima;
            cantidad = myArray[i].cantidad;
            const sql = "INSERT INTO planificaciones_02  (id_plan,id_materiaprima, cantidad) VALUES (?,?,?) "
            const result = await pool.query(sql,[id, materiaprima, cantidad ]);
        }
    } catch (e) {
        manejo_de_errorHelper(e);
    }    
   return await 'exito';

}
//**************************************************** */
helpers.DeleteDetTurno = async (id_turno) => {
    try {
        const sql = " DELETE  FROM produccion_diaria_01 Where id_produccion = ?"
        const result = await pool.query(sql,[id_turno]);                   
        //const sql2 = "DELETE  FROM produccion_diaria_02 Where id_produccion = ?"
      //  const result2 = await pool.query(sql2,[id_turno]);                   
    } catch (e) {
        manejo_de_errorHelper(e);
     }   
     return await 'exito';    
 
};
//********************************************************************** */
helpers.DeleteActividadesxmaquina = async (id_maestro) => {
    try {
         const sql = "DELETE FROM produccion_diaria_03 Where id_produccion = ?"
         const result = await pool.query(sql,[ id_maestro]);                      
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};

//********************************************************************** */
helpers.ValidarActividadesxmaquina = async (id_maestro, id_maquina, id_actividad) => {
    let resultado = 0;
    try {
         const sql = "Select * From produccion_diaria_03 Where id_produccion = ? and id_maquina = ? and id_actividad = ?"
         const result = await pool.query(sql,[ id_maestro,id_maquina, id_actividad ]);    
         if (result.length > 0) {
            resultado = 1;
         }
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await resultado;    
};
//********************************************************************** */
helpers.InsertarActividadesxmaquina = async (data,id_maestro) => {
    const myArray = JSON.parse(data); 
    var id_maquina , filtro, id_actividad, fechahora, valor ;
    var elim = await helpers.DeleteActividadesxmaquina (id_maestro);
    try {
       for ( var i = 0 ; i < myArray.length; i++){
            id_maquina = myArray[i].Id_maquina;
            id_actividad = myArray[i].Id_actividad;
            fechahora = myArray[i].Fechahora;
            valor = myArray[i].Valor;
            filtro = myArray[i].Filtro;
            resultado = await helpers.ValidarActividadesxmaquina(id_maestro,id_maquina,id_actividad);
            if (resultado <= 0) {
                const sql = "INSERT INTO produccion_diaria_03 (id_produccion, id_maquina,id_actividad,fecha_hora,valor,filtro) VALUES (?,?,?,?,?, ?)"
                const result = await pool.query(sql,[parseInt(id_maestro), parseInt(id_maquina), parseInt(id_actividad), fechahora, valor,filtro ]);                         
            }
          };
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};

//************************************************************************** */
helpers.Nombredelgrupo = async (id_grupo) => {
    let nombregrupo = '';
    try {
        if (id_grupo >=999) {
            nombregrupo = 'Todos';
        }else {
            const sql = "SELECT descripcion from grupos where id_grupo = ? "
            const result = await pool.query(sql,[parseInt(id_grupo)]);    
            if (result.length > 0)    {
                nombregrupo = result[0].descripcion;
            }
        }
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await nombregrupo;    
};
//*************************************************************************** */
helpers.EliminarRegistrosDeMpconsumo2 = async (arrayElim, Id_registro) => {
    var id_materiaprima;
    try {
       for ( var i = 0 ; i < arrayElim.length; i++){
            id_materiaprima = arrayElim[i].Id_materiaprimaD;
            id_maquina = arrayElim[i].Id_maquinaD;
            const sql = "DELETE FROM produccion_diaria_02 Where id_produccion = ? and id_materiaprima = ? and id_maquina = ? "
            const result = await pool.query(sql,[parseFloat(Id_registro) ,parseInt(id_materiaprima),  parseInt(id_maquina)]);     
          }

    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};


//************************************************************************** */

helpers.EliminarRegistrosDeMpconsumo = async (arrayElim, Id_registro) => {
    var id_materiaprima;
    try {
       for ( var i = 0 ; i < arrayElim.length; i++){
            id_materiaprima = arrayElim[i].Id_materiaprimaD;
            const sql = "DELETE FROM produccion_diaria_02 Where id_produccion = ? and id_materiaprima = ? "
            const result = await pool.query(sql,[parseFloat(Id_registro) ,parseInt(id_materiaprima)]);     
          }

    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};



//************************************************************************ */
helpers.UpdatedeMateriaprima2 = async (data,id_maestro, tabladeeliminados) => {
    const myArray = JSON.parse(data); 
    const ArrayElim = JSON.parse(tabladeeliminados); 
    var id_maquina , cantidad ;
    try {
        var exiElim = await helpers.EliminarRegistrosDeMpconsumo(ArrayElim, id_maestro)
       for ( var i = 0 ; i < myArray.length; i++){
            id_materiaprima = myArray[i].Id_materiaprima;
            cantidad = myArray[i].cantidad;
            const sql = "UPDATE  produccion_diaria_02  SET  cantidad = cantidad +  ?    Where   id_produccion = ? and   id_materiaprima =  ?  "
            const result = await pool.query(sql,[parseFloat(cantidad) ,parseInt(id_maestro), parseInt(id_materiaprima) ]);     
            //console.log ('Se actulizaron : ' + result.affectedRows + ' registros') ;  
            if (result.affectedRows <= 0 ) {
                const sql2 = "INSERT INTO  produccion_diaria_02 (id_produccion, id_materiaprima, cantidad)  VALUES (?,?,?) "
                const result2 = await pool.query(sql2,[ parseInt(id_maestro), parseInt(id_materiaprima), parseFloat(cantidad)]);   
            }else {
                //console.log ('NO SE inserto este registro : ' +  id_materiaprima ) ;        
            }     
            //console.log ('Se actulizaron : ' + result.affectedRows + ' registros') ;      
          };
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};

//************************************************************************ */
helpers.UpdatedeMateriaprima = async (data,id_maestro,tabladeeliminados) => {
    const myArray = JSON.parse(data); 
    const ArrayElim = JSON.parse(tabladeeliminados); 
    var id_maquina , cantidad , filtro;
    try {
       var exiElim = await helpers.EliminarRegistrosDeMpconsumo2(ArrayElim, id_maestro)
       for ( var i = 0 ; i < myArray.length; i++){
            id_materiaprima = myArray[i].Id_materiaprima;
            id_maquina = myArray[i].Id_maquina;
            cantidad = myArray[i].cantidad;
            filtro = myArray[i].filtro;
            const sql = "UPDATE  produccion_diaria_02  SET  cantidad = cantidad +  ?    Where   id_produccion = ? and   id_materiaprima =  ? and  id_maquina = ? "
            const result = await pool.query(sql,[parseFloat(cantidad) ,parseInt(id_maestro), parseInt(id_materiaprima),  parseInt(id_maquina) ]);     
            if (result.affectedRows <= 0 ) {
                const sql2 = "INSERT INTO  produccion_diaria_02 (id_produccion, id_materiaprima, cantidad, id_maquina, filtro)  VALUES (?,?,?,?,?) "
                const result2 = await pool.query(sql2,[ parseInt(id_maestro), parseInt(id_materiaprima), parseFloat(cantidad), parseInt(id_maquina), filtro]);   
            }else {
                //console.log ('NO SE inserto este registro : ' +  id_materiaprima ) ;        
            }     
            //console.log ('Se actulizaron : ' + result.affectedRows + ' registros') ;      
          };
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};


//************************************************************************* */

helpers.UpdatedeTurno = async (data,id_maestro) => {
    const myArray = JSON.parse(data);
    var id_maquina , id_unico ,cantidad, peso , merma , kgentrantes, horas  ;
    try {
        console.log(myArray)
       for ( var i = 0; i < myArray.length; i++){
                    id_maquina =   parseInt('0'+ myArray[i].Id_maquina);
                    id_unico = myArray[i].Id_unico;
                    cantidad = parseFloat('0' + myArray[i].cantidad);
                    peso = parseFloat('0' + myArray[i].peso);
                    merma = parseFloat('0' + myArray[i].merma);
                    kgentrantes = parseFloat('0' + myArray[i].kgentrantes);
                    horas = parseFloat('0' + myArray[i].horastrabajdas);
                  //  console.log('id maquima:' + id_maquina + ' cantidad:' + cantidad + ' peso:' + peso + ' merma: ' + merma);
                    const sql = "UPDATE  produccion_diaria_01  SET  cantidad = ?,  peso = ? , merma = ?,  kilosentrantes = ? ,  horastrabajadas = ?  Where   id_produccion = ? and   id_maquina =  ? and id_unico = ? "
                    const result = await pool.query(sql,[parseFloat(cantidad),parseFloat(peso), parseFloat(merma) , kgentrantes  ,  horas ,parseInt(id_maestro), parseInt(id_maquina), id_unico.trim() ]);                   
          };
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};
//*************************************************** */

helpers.EliminarRegistrosEditTurno01 = async (arrayElim, Id_registro) => {
    var id_maquina;
    try {
       for ( var i = 0 ; i < arrayElim.length; i++){
            id_maquina = arrayElim[i].Id_maquinaD;
            id_unico = arrayElim[i].Id_unicoD;
            const sql = "DELETE FROM produccion_diaria_01 Where id_produccion = ? and id_maquina = ? and id_unico = ?"
            const result = await pool.query(sql,[parseFloat(Id_registro) ,parseInt(id_maquina), id_unico ]);     
          }

    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};

//************************* */
helpers.UpdatedeTurno_al_editar = async (data,id_maestro,tabladeeliminados) => {
    const myArray = JSON.parse(data);
    const ArrayElim = JSON.parse(tabladeeliminados); 
    var id_maquina , orden, operador, ayudante1,ayudante2,  nomb_operador, nomb_ayudante1, nomb_ayudante2, nomb_producto  ;
    try {
       var exiElim = await helpers.EliminarRegistrosEditTurno01(ArrayElim,id_maestro)
       for ( var i = 0; i < myArray.length; i++){
                    id_maquina = myArray[i].Id_maquina;
                    orden = myArray[i].orden;
                    id_unico = myArray[i].Id_unidco;
                    operador = parseInt( '0' + myArray[i].Operador ) ;
                    nomb_operador = await helpers.trabajador(operador);
                    ayudante1 = parseInt( '0' +myArray[i].Ayudante1 );
                    nomb_ayudante1 = await helpers.trabajador(ayudante1);
                    ayudante2 = parseInt( '0' +  myArray[i].Ayudante2 );
                    nomb_ayudante2 = await helpers.trabajador(ayudante2);
                    nomb_producto = await helpers.productoasociado(orden);
                    const sql = "UPDATE  produccion_diaria_01  SET  orden = ?,  operador = ? , nombre_operador = ?,  ayudante1 = ? ,  ayudante2 = ?,  nombre_ayudante1 = ? , nombre_ayudante2 = ?, descripcion_articulo = ?   Where   id_produccion = ? and   id_maquina =  ?  and id_unico = ?"
                    const result = await pool.query(sql,[orden.trim(), operador,nomb_operador,ayudante1,ayudante2,nomb_ayudante1,nomb_ayudante2,nomb_producto, parseInt('0' + id_maestro), parseInt('0' + id_maquina), id_unico ]);                   
                    if (result.affectedRows <= 0 ) {
                        id_unico = uuidv4();
                        const sql2 = "INSERT INTO  produccion_diaria_01 (id_produccion, id_maquina, id_unico , orden , operador, ayudante1, ayudante2,nombre_ayudante1,nombre_ayudante2,descripcion_articulo, nombre_operador )  VALUES (?,?,?,?,?,?,?,?,?,?,?) "
                        const result2 = await pool.query(sql2,[ parseInt(id_maestro), parseInt(id_maquina), id_unico, orden, operador, ayudante1, ayudante2, nomb_ayudante1,nomb_ayudante2, nomb_producto, nomb_operador ]);   
                    }else {
                        //console.log ('NO SE inserto este registro : ' +  id_materiaprima ) ;        
                    }     
        
          };
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};

//**************************************************** */

helpers.InsertDetOpenTurno = async (data,id_maestro) => {
    const myArray = JSON.parse(data); 
    var id_maquina , orden, operador, ayudante1,ayudante2,  nomb_operador, nomb_ayudante1, nomb_ayudante2, nomb_producto  ;
    try {
       for ( var i = 0 ; i < myArray.length; i++){
                    id_maquina = myArray[i].Id_maquina;
                    orden = myArray[i].orden;
                    operador = parseInt( '0' + myArray[i].Operador ) ;
                    nomb_operador = await helpers.trabajador(operador);
                    ayudante1 = parseInt( '0' +myArray[i].Ayudante1 );
                    nomb_ayudante1 = await helpers.trabajador(ayudante1);
                    ayudante2 = parseInt( '0' +  myArray[i].Ayudante2 );
                    nomb_ayudante2 = await helpers.trabajador(ayudante2);
                    nomb_producto = await helpers.productoasociado(orden);

                    const sql = "INSERT INTO produccion_diaria_01  (id_produccion, id_maquina,orden,operador,ayudante1,ayudante2,nombre_operador,nombre_ayudante1,nombre_ayudante2,descripcion_articulo ) VALUES (?,?,?,?,?,?,?,?,?,?) "
                    const result = await pool.query(sql,[id_maestro, parseInt(id_maquina),orden,parseInt(operador),parseInt(ayudante1),parseInt(ayudante2), nomb_operador , nomb_ayudante1 , nomb_ayudante2, nomb_producto ]);                   
          };
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};
//******************************************************************* */
helpers.IdPlanxOrden= async (orden) => {
    let idplan = '0';
    try {
        const sql = "select id_plan from planificaciones Where numerodeorden = ? "
        const result = await pool.query(sql,[orden]); 
        if (result.length > 0) {
            idplan =  result[0].id_plan;
        }  
     } catch (e) {
        manejo_de_errorHelper(e);
     } 
     return idplan;  
 
}    
//******************************************************************** */
helpers.Extraecadena2 = async (miArreglo) => {
    let cadena = '(';
    let delimitador = '';
    let orden = '';
    let idplan = '';
        for (var i=0; i< miArreglo.length; i++ ) {
            if ((i + 1) < miArreglo.length ) {
                delimitador = ','
            } else {
                delimitador = ')';
            }
            orden = miArreglo[i].orden;
           // console.log( 'la orden del registro: ' +  i +  ' es : ' + orden)
            idplan = await helpers.IdPlanxOrden(orden);
        //    console.log( 'el id de la orden: ' +  orden +  ' es : ' + idplan)
            cadena = cadena + idplan + delimitador;
            
        } // fin del for      

   return cadena ;
} // fin de  Extraecadena2
//*********************************************************************** */
helpers.InsertarMateriaPrimaTurno2 = async (data, idreg) => {
    const myArray = JSON.parse(data);  
    var Id_maquina , filtro , maquina, orden ;
    try {
         for(i=0; i< myArray.length; i++) {
            Id_maquina = myArray[i].Id_maquina;
            filtro =  myArray[i].filtro;
            maquina = myArray[i].Des_maquina;
            orden = myArray[i].orden;
            const sql = "SELECT planificaciones_02.id_materiaprima , materiaprima.descripcion As descripcionMP FROM  materiaprima, planificaciones_02, planificaciones Where  planificaciones.id_plan = planificaciones_02.id_plan and planificaciones_02.id_materiaprima = materiaprima.id And  planificaciones.numerodeorden = ? order by materiaprima.id ";
            const result = await pool.query(sql, [orden]); 
            for (r=0; r< result.length;r++) {
                const id_materiaprima = result[r].id_materiaprima;
                const sql2  ="INSERT INTO produccion_diaria_02 (id_produccion,  id_materiaprima, id_maquina,filtro,des_maquina)  VALUES (?,?,?,?,?) ";
                const result2 = await pool.query(sql2, [idreg, id_materiaprima, Id_maquina, filtro, maquina]); 
            }  
         }                      
     } catch (e) {
        manejo_de_errorHelper(e);
     } 
     return 'exito';  

} // fin de InsertarMateriaPrimaTurno

//************************************************************************* */
helpers.InsertarMateriaPrimaTurno = async (data, idreg) => {
    const myArray = JSON.parse(data);  
    try {
         
         for (i=0; i<myArray.length; i++ ) {
            const orden = myArray[i].orden;
            const id_maquina = myArray[i].Id_maquina;
            const filtro = myArray[i].filtro;
            const sql = "SELECT  planificaciones_02.id_materiaprima , materiaprima.descripcion As descripcionMP FROM  materiaprima, planificaciones_02, planificaciones Where    planificaciones.id_plan = planificaciones_02.id_plan and  planificaciones_02.id_materiaprima = materiaprima.id And planificaciones.numerodeorden = ? order by materiaprima.id ";
            const result = await pool.query(sql, [orden]); 
                for (r=0; r< result.length;r++) {
                    const id_materiaprima = result[r].id_materiaprima;
                    const sql2  ="INSERT INTO produccion_diaria_02 (id_produccion, orden, id_materiaprima, id_maquina, filtro)  VALUES (?,?,?,?,?) ";
                    const result2 = await pool.query(sql2, [idreg, orden,id_materiaprima, id_maquina, filtro]); 
                }
         }

     } catch (e) {
        manejo_de_errorHelper(e);
     } 
     return 'exito';  

} // fin de InsertarMateriaPrimaTurno
//******************************************************************* */
helpers.Extraecadena = (miArreglo) => {

    let cadena = '(';
    let delimitador = '';

    for (var i=0; i< miArreglo.length; i++ ) {
        if ((i + 1) < miArreglo.length ) {
            delimitador = ','
        } else {
            delimitador = ')';
        }
         cadena = cadena + miArreglo[i].id_produccion + delimitador;
   } // fin del for
   return cadena ;

};
//****************************************************** */
helpers.ProcesarSaint = async (data) => {
    const myArray = JSON.parse(data); 
    const cadena = helpers.Extraecadena(myArray);
    try {
       const sql1 = "SELECT   productos.id_productos ,   productos.descripcion, sum(produccion_diaria_01.cantidad) As TotalProduccion , sum(produccion_diaria_01.peso) As TotalPeso, produccion_diaria.cantidadmerma As TotalMerma FROM produccion_diaria_01, produccion_diaria, departamento, productos, planificaciones Where produccion_diaria.id_produccion = produccion_diaria_01.id_produccion and  produccion_diaria.id_dpto = departamento.id_dpto and  produccion_diaria_01.orden = planificaciones.numerodeorden and planificaciones.id_producto = productos.id_productos and produccion_diaria.id_produccion in " + cadena + " and  produccion_diaria.status = 'Cerrado' group by  productos.codigo order by  productos.codigo"
       //console.log( 'la cadena es : ' +  sql1) ;   
       const result = await pool.query(sql1); 
       if (result.length >0) {
           // insertro registro en la tabla encabezado SAOPEI DE SAINT
           

       }
       for (var i=0; i< result.length; i++) {
             
       } // fin del for

     } catch (e) {
        manejo_de_errorHelper(e);
     }   
     return await 'exito';    
}; // fin de ProcesarSaint

//************************************** */

helpers.Connsqlserver =  (configuracion) => {

    var params = [];
    var sql = "select * from pokemon where number = @number";
    // For each param do: db.buildParams(params, "name", TYPES.type, variable)
  //  db.buildParams(params, "number", TYPES.Int, number);
 /// //  db.query(params, sql, result => {
 //     console.log(result);
 //   });
    return  'exito'; 
};

//********************************************** */
helpers.Validaridmaquina = async (idmaster,idmaquina) => {
    let valor = 0;
    try {
      const sql2 = "SELECT id_dpto, id_maquina FROM departamento_01 Where id_dpto = ? and id_maquina = ?"
      const result2 = await pool.query(sql2, [idmaster, idmaquina ]); 
      if (result2.length >0) {
           valor = 1;
        };
      
    } catch (e) {
        manejo_de_errorHelper(e);
    } 
    return valor;  

}
//******************************************** */
helpers.DeletedetalleDpto = async (id) => {
    try {
       const sql2 = "DELETE FROM departamento_01 Where id_dpto = ?"
       resultado = await pool.query(sql2,id)
    } catch (e) {
        manejo_de_errorHelper(e);
    } 
    return 'exito';  

};
//******************************************** */
helpers.ValidarActividad = async (idmaster,idactividad) => {
    let valor = 0;
    try {
      const sql2 = "SELECT id_dpto, id_actividad FROM departamento_02 Where id_dpto = ? and id_actividad = ?"
      const result2 = await pool.query(sql2, [idmaster, idactividad ]); 
      if (result2.length >0) {
           valor = 1;
        };
      
    } catch (e) {
        manejo_de_errorHelper(e);
    } 
    return valor;  

}


//******************************************* */
helpers.InsertarActividadesDearea = async (id,tablaactividades) => {
    const myArray = JSON.parse(tablaactividades); 
    const id_master = id;
    try {
         for (var i=0; i< myArray.length; i++) {
            const id_actividad =  myArray[i].Id_actividad;
            const exist = await helpers.ValidarActividad(id_master,id_actividad);
            if (exist < 1) {
                const sql2 = "INSERT INTO departamento_02 (id_dpto, id_actividad) VALUES (?,?)"
                const result2 = await pool.query(sql2, [id_master, id_actividad ]);    
            }
         } // fin de ciclo for
     } catch (e) {
        manejo_de_errorHelper(e);
     } 
     return 'exito';  
};

//******************************************** */
helpers.InsertarMaquinasDearea = async (id,tablamaquinas) => {
    const myArray = JSON.parse(tablamaquinas); 
    const id_master = id;
    try {
         for (var i=0; i< myArray.length; i++) {
            const id_maquina =  myArray[i].Id_maquina;
            const exist = await helpers.Validaridmaquina(id_master,id_maquina);
            if (exist < 1) {
                const sql2 = "INSERT INTO departamento_01 (id_dpto, id_maquina) VALUES (?,?)"
                const result2 = await pool.query(sql2, [id_master, id_maquina ]);    
            }
         } // fin de ciclo for
     } catch (e) {
        manejo_de_errorHelper(e);
     } 
     return 'exito';  
};
//***************************************************** */
helpers.ValidarMP = async (idmaster,idmMp) => {
    let valor = 0;
    try {
      const sql2 = "SELECT id_formula, id_materiaprima FROM formula_01 Where id_formula = ? and id_materiaprima = ?"
      const result2 = await pool.query(sql2, [idmaster, idmMp ]); 
      if (result2.length >0) {
           valor = 1;
        };
      
    } catch (e) {
        manejo_de_errorHelper(e);
    } 
    return valor;  

}

//******************************************** */
helpers.Deletedetalleformula = async (id) => {
    try {
       const sql2 = "DELETE FROM formula_01 Where id_formula = ?"
       resultado = await pool.query(sql2,id)
    } catch (e) {
        manejo_de_errorHelper(e);
    } 
    return 'exito';  

};

//***************************************************** */
helpers.InsertarMpdeFormulas = async (id,tablaMP) => {
    const myArray = JSON.parse(tablaMP); 
    const id_master = id;
    try {
         for (var i=0; i< myArray.length; i++) {
            const id_mp =  myArray[i].Id_MP;
            const porcentaje = myArray[i].Porcentaje;
            const exist = await helpers.ValidarMP(id_master,id_mp);
            if (exist < 1) {
                const sql2 = "INSERT INTO formula_01 (id_formula, id_materiaprima, porcentaje) VALUES (?,?,?)"
                const result2 = await pool.query(sql2, [id_master, id_mp, parseFloat(porcentaje) ]);    
            }
         } // fin de ciclo for
     } catch (e) {
        manejo_de_errorHelper(e);
     } 
     return 'exito';  
};

//***************************************************** */
helpers.ValidarTrabajadorgrup = async (idmaster,idtrabajador) => {
    let valor = 0;
    try {
      const sql2 = "SELECT id_grupo FROM grupos_01 Where id_grupo = ? and id_trabajador = ?"
      const result2 = await pool.query(sql2, [idmaster, idtrabajador ]); 
      if (result2.length >0) {
           valor = 1;
        };
      
    } catch (e) {
        manejo_de_errorHelper(e);
    } 
    return valor;  

}


//******************************************** */

helpers.Deletedetallegrupos = async (id) => {
    try {
       const sql2 = "DELETE FROM grupos_01 Where id_grupo = ?"
       resultado = await pool.query(sql2,id)
    } catch (e) {
        manejo_de_errorHelper(e);
    } 
    return 'exito';  

};

//****************************************************** */
helpers.InsertarTrabdeGRupos = async (id,tabla) => {
    const myArray = JSON.parse(tabla); 
    const id_master = id;
    try {
         for (var i=0; i< myArray.length; i++) {
            const id_trabajador =  myArray[i].Id_trabajador;
            const rol = myArray[i].rol;
            const exist = await helpers.ValidarTrabajadorgrup(id_master,id_trabajador);
            if (exist < 1) {
                const sql2 = "INSERT INTO grupos_01 (id_grupo, id_trabajador, rol) VALUES (?,?,?)"
                const result2 = await pool.query(sql2, [id_master, id_trabajador, rol ]);    
            }
         } // fin de ciclo for
     } catch (e) {
        manejo_de_errorHelper(e);
     } 
     return 'exito';  
};

//************************************************************************** */

helpers.EliminarRegistrosDeMpconsumoPlantilla = async (arrayElim, Id_registro) => {
    var id_materiaprima;
    try {
       for ( var i = 0 ; i < arrayElim.length; i++){
            id_materiaprima = arrayElim[i].Id_materiaprimaD;
            const sql = "DELETE FROM plantillaconsumo_01 Where id_plantilla = ? and id_materiaprima = ? "
            const result = await pool.query(sql,[parseFloat(Id_registro) ,parseInt(id_materiaprima)]);     
          }

    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};



//************************************************************************ */
helpers.UpdatedeMateriaprimaPlantilla = async (data,id_maestro, tabladeeliminados) => {
    const myArray = JSON.parse(data); 
    const ArrayElim = JSON.parse(tabladeeliminados); 
    var id_maquina , cantidad ;
    try {
        var exiElim = await helpers.EliminarRegistrosDeMpconsumoPlantilla(ArrayElim, id_maestro)
       for ( var i = 0 ; i < myArray.length; i++){
            id_materiaprima = myArray[i].Id_materiaprima;
            cantidad = myArray[i].cantidad;
            const sql = "UPDATE  plantillaconsumo_01  SET  cantidad = ?     Where   id_plantilla = ? and   id_materiaprima =  ?  "
            const result = await pool.query(sql,[parseFloat(cantidad) ,parseInt(id_maestro), parseInt(id_materiaprima) ]);                
            if (result.affectedRows <= 0 ) {
                const sql2 = "INSERT INTO  plantillaconsumo_01 (id_plantilla, id_materiaprima, cantidad)  VALUES (?,?,?) "
                const result2 = await pool.query(sql2,[ parseInt(id_maestro), parseInt(id_materiaprima), parseFloat(cantidad)]);   
            }else {
               // console.log ('NO SE inserto este registro : ' +  id_materiaprima ) ;        
            }     
              //  console.log ('Se actulizaron : ' + result.affectedRows + ' registros') ;      
          };
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await 'exito';    
};
//*************************************************************************** */
helpers.CerrarPlanesXlotes = async (data) => {
    const myArray = data.split(","); 
    var id_plan ;
    var cantidad_ordenes = 0;
    console.log(myArray)
    try {
       for ( var i = 0 ; i < myArray.length; i++){
            id_plan = myArray[i];
            console.log('planificacion numero: ' + id_plan);
            const sql = "UPDATE  planificaciones  SET  status = 'Cerrado'     Where   id_plan = ? "
            const result = await pool.query(sql,[parseInt('0' + id_plan)]);                
            if (result.affectedRows > 0 ) {
                cantidad_ordenes++;
            }else {
               // console.log ('SE actualizo  registro ) ;        
            }     
              //  console.log ('NO Se actulizaron ) ;      
          };
    } catch (e) {
        manejo_de_errorHelper(e);
    }   
    return await cantidad_ordenes;    
};



//************************************************************************ */
 
function  manejo_de_errorHelper (err)  {
    rollbar.error(err.stack + 'modulo Helpers');
    console.log(err.stack);
 }
 

module.exports =  helpers;
