const passport = require('passport');
const LocalStrategy = require('passport-local').Strategy;

const pool = require('../database');
const helpers = require('../lib/helpers');



//* metodos para validar login del usuario
passport.use('local.singin', new LocalStrategy({
 usernameField: 'username',
 passwordField: 'password',
 passReqToCallback: true

}, async (req, username, password, done) => {
    const rows = await pool.query('SELECT * FROM usuarios Where username = ?', [username]);
     if (rows.length >0) {
        const user = rows[0];
        const validPassword = await helpers.matchPassword(password,user.password);
        
        if (validPassword) {
            
             done(null,user,req.flash('mensajeOk','Bienvenido '));
            
        } else {
            done(null,false,req.flash('message','Contraseña Invalida'));
        }
    } else {
        console.log('USUARIo NO EXISTE')
        return done(null, false, req.flash('message', 'El usuario no existe'));
        

    }
}));

//* metodos para registrar usuarios
passport.use('local.signup', new LocalStrategy({
    // aqui se relacionan o se referencian los nombres de los inputs de tu formulario de registro(signuo,hbs)
    // username y password
    usernameField: 'username',
    passwordField: 'password',
    passReqToCallback: true   //esta opcion me permite recibir en la funcion el req.body de mi formulario para otros campos
}, async (req, username, password, done) => {
    const {nombre, email, rol} = req.body;
    
    const newUser = {
        username,
        password,
        nombre,
        rol,
        email

    }
    newUser.password = await helpers.encryptPassword(password);
    const sql = "INSERT INTO usuarios (username, password, fullname, rol, email) VALUES (?,?,?,?,?)";
    const result = await pool.query(sql,[newUser.username,newUser.password,newUser.nombre,newUser.rol, newUser.email]);
    newUser.id = result.insertId;
    return done(null,newUser);
    //console.log(result);

} ));



  passport.serializeUser((user, done) => {
    //console.log(user); 
    done(null, user.id);
  });
  
  
  passport.deserializeUser(async (id, done) => {
    const rows = await pool.query('SELECT * FROM usuarios WHERE id = ?', [id]);
    if (rows.length > 0) {
        done(null, rows[0]);
    } else {
        console.log('no esta devolviendo nada');  
        done(null, null);
    }
  });

