const express = require('express');
const router = express.Router();

const passport = require('passport');
const { isLoggedIn, isNotLoggedIn } = require('../lib/auth');




//*** rutas para login de usuarios/

router.get('/singin', isNotLoggedIn, (req, res) => {
  res.render('auth/singin')    ;
});



router.post('/singin', isNotLoggedIn, (req, res, next) => {

  passport.authenticate('local.singin', {
    successRedirect: '/profile',
    failureRedirect: '/singin',
    failureFlash: true
  })(req, res, next);


});

//*** rutas para registro de usuarios/
router.get('/signup', isNotLoggedIn, (req, res) => {
  
  res.render('auth/signup')    ;
});

router.post('/signup', isNotLoggedIn, passport.authenticate('local.signup', {
    successRedirect: '/profile',
    failureRedirect: '/signup',
    failureFlash: true
  }));


router.get('/profile', isLoggedIn, (req,res) => {
  res.render('profile');
});

router.get('/logout',  (req,res) => {
 req.logOut();
 res.redirect('/singin');
});

module.exports = router;
