const express = require('express');
const router = express.Router();

// esta es la llamada a la conexion de mi base de datos 
const pool = require('../database');
const { isLoggedIn } = require('../lib/auth');

const helpers = require('../lib/helpers');

const path = require('path');
const fs = require('fs');

const Rollbar = require("rollbar");
const { validar_entero } = require('../lib/helpers');

var rollbar = new Rollbar({
   accessToken: 'ce7c7a535a6041c59033de55e96cd691',
   captureUncaught: true,
   captureUnhandledRejections: true
 });
//****************************************************** */
//***Rutas para seguimiento de la produccion */
///
router.get('/actividades_plan_dia/:id&:fecha', isLoggedIn, async function(req, res) {
   try {
      const el_id = helpers.validar_entero (req.params.id);
      const fecha = req.params.fecha;
      const consulta = 'select id_plan, id_unico, dia, id_actividad, hora_inicio, hora_final, fecha, nombre_actividad, nombre_producto, id_producto from planificaciones_01 where id_plan  = ?  and fecha = ? order by hora_inicio';
      const data = await pool.query (consulta, [el_id, fecha]);
      res.send(data);
      
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//********************************************************** */
router.get('/lotes_plan_dia/:id&:id_unico', isLoggedIn, async function(req, res) {
   try {
      const el_id = helpers.validar_entero (req.params.id);
      const el_id_unico = helpers.validar_entero (req.params.id_unico);
      const consulta = 'select id_plan, id_unico, nro_registro, id_producto,id_actividad, lote, cantidad, filtro from planificaciones_02 where id_plan = ? and  id_unico = ? order by nro_registro';
      const data = await pool.query (consulta, [el_id, el_id_unico]);
      res.send(data);
      
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//********************************************************** */
router.get('/listar-programaciones/:id', isLoggedIn, async function(req, res) {
   try {
      const el_id = helpers.validar_entero (req.params.id);
      const consulta = 'Select planificaciones.id_plan, planificaciones.numerodeorden, DATE_FORMAT(planificaciones.fechainicial, "%d-%m-%Y") AS fecha_i ,  DATE_FORMAT(planificaciones.fechafinal, "%d-%m-%Y") AS fecha_f , planificaciones.horas_disponibles  from planificaciones Where  planificaciones.estado = 2 and  planificaciones.id_dpto = ?';
      const data = await pool.query (consulta, [el_id]);
      res.send(data);
      
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});

//******************************************** */
router.get('/actividades_programaciones/:id', isLoggedIn, async function(req, res) {
   try {
      const el_id = req.params.id;
      const consulta = 'SELECT planificaciones_01.id_plan, planificaciones_01.id_unico, dia, DATE_FORMAT(planificaciones_01.fecha, "%Y-%m-%d") as fecha_dia, planificaciones_01.id_actividad,  planificaciones_01.nombre_actividad, planificaciones_01.id_producto,  planificaciones_01.nombre_producto,  planificaciones_01.hora_inicio, planificaciones_01.hora_final  from planificaciones_01, planificaciones Where  planificaciones.id_plan = planificaciones_01.id_plan and  planificaciones.numerodeorden = ?';      
      const data = await pool.query (consulta, [el_id]);
      res.send(data);
      
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});

//******************************************* */
router.get('/create-seguimiento-prod', isLoggedIn, async function(req, res) {
   try {          
  
            const lista_productos =  await pool.query("SELECT id_productos, descripcion  FROM productos");
            const lista_areas =  await pool.query("SELECT id_dpto, nombre  FROM departamento");
            const lista = [{ lista_areas},  {lista_productos}];
            res.render('links/create-ejecucion',{lista});  
         } catch (err) {
             manejo_de_error (err,req,res );
         }
});
//*********************************************************************** */
router.post('/create-seguimiento-prod', async (req,res) => {
   try {
      //***** */
      const {tipo_de_submit, tabla_actividades, tabla_lotes, area, notas,fecha, id_programacion,id_plan_asociado} = req.body;
      const  newplan = {
            area : helpers.validar_entero(area),
            notas,             
            fecha,
            id_programacion,
            id_plan_asociado : helpers.validar_entero(id_plan_asociado),
            user_id: req.user.id
      };
   
       if (parseInt(tipo_de_submit) <=0 ) {   

          const sqlinsert = "INSERT INTO  seguimiento_produccion (fecha_registro,id_dpto, numerodeprogramacion,notas,id_usuario,id_planificacion) values (?,?,?,?,?,?)";
          const resultado = await pool.query(sqlinsert,[newplan.fecha,newplan.area,newplan.id_programacion,newplan.notas,newplan.user_id, newplan.id_plan_asociado] );

          const exito2 = await helpers.InsertDetalle_seguimiento([resultado][0].insertId, tabla_actividades, tabla_lotes ) ;

             res.redirect('./crud-ejecucion-diaria');     
           
         } else {
            res.redirect('./crud-ejecucion-diaria');                 
         }
   
//****** */

   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//************************************** */
router.get('/edit-seguimiento-prod/:id', isLoggedIn, async function(req, res) {
   try {    
                  
            const el_id = helpers.validar_entero(req.params.id);
            const sql_reg = 'Select LPAD(seguimiento_produccion.numero_seguimiento,5,"0") as numero_seguimiento, DATE_FORMAT(seguimiento_produccion.fecha_registro, "%Y-%m-%d") as fecha,  seguimiento_produccion.numerodeprogramacion, departamento.nombre as el_departamento, departamento.id_dpto, seguimiento_produccion.notas, seguimiento_produccion.estado from seguimiento_produccion, departamento  where   seguimiento_produccion.id_dpto = departamento.id_dpto and  departamento.id_dpto = seguimiento_produccion.id_dpto And  seguimiento_produccion.numero_seguimiento = ?';

            const registro = await pool.query (sql_reg,[el_id])

            const newParam = {
               proxima_o: registro[0].numero_seguimiento,
               fecha : registro[0].fecha,
               programacion : registro[0].numerodeprogramacion,
               id_dpto : registro[0].id_dpto,
               nombre_dpto : registro[0].el_departamento,
               notas : registro[0].notas,
               estado : registro[0].estado,
               nombre_estado : helpers.nombre_estado(registro[0].estado),
               id_registro : el_id
            };

            const lista_detalle = await pool.query('SELECT seguimiento_produccion_01.numero_seguimiento, seguimiento_produccion_01.id_unico, seguimiento_produccion_01.dia, DATE_FORMAT(seguimiento_produccion.fecha_registro, "%Y-%m-%d") as fecha_dia,  seguimiento_produccion_01.id_actividad, seguimiento_produccion_01.nombre_actividad,   seguimiento_produccion_01.id_producto, seguimiento_produccion_01.nombre_producto,  seguimiento_produccion_01.hora_inicio,  seguimiento_produccion_01.hora_final   from  seguimiento_produccion_01, seguimiento_produccion  Where  seguimiento_produccion.numero_seguimiento = seguimiento_produccion_01.numero_seguimiento and   seguimiento_produccion_01.numero_seguimiento = ? ', [el_id]);

            const lista_detalle_02 = await pool.query('SELECT numero_seguimiento, id_unico, nro_lote as nro_registro, id_producto, id_actividad, lote, cantidad, filtro   from   seguimiento_produccion_02  Where numero_seguimiento = ?', [el_id]);


            const lista_productos =  await pool.query("SELECT id_productos, descripcion  FROM productos");
            const lista_areas =  await pool.query("SELECT id_dpto, nombre  FROM departamento");
            const lista = [  {newParam},  { lista_areas},  {lista_productos}, {lista_detalle}, {lista_detalle_02}];

            res.render('links/edit-seguimiento',{lista});  
         } catch (err) {
             manejo_de_error (err,req,res );
         }
});
///************************ */
router.post('/edit-seguimiento-prod', async (req,res) => {
   try {

      const {id_registro, tabla_actividades, tabla_lotes,tabledeleted1,notas,tipo_de_submit, tabla_lotes_deleted,status } = req.body;
   
      const  newplan = {
         id_registro : helpers.validar_entero(id_registro),
         notas,
         status : helpers.validar_entero(status),
         user_id: req.user.id
      };
       //console.log(tabla_lotes_deleted)
       if (parseInt(tipo_de_submit) <= 0 ) {   
            const sqlupdate = "UPDATE seguimiento_produccion set notas = ? , estado = ? Where numero_seguimiento = ? ";
            const resultado = await pool.query(sqlupdate,[newplan.notas, newplan.status, newplan.id_registro] );

            const exito2 = await helpers.Update_detalles_Seguimiento_prod(tabla_actividades,newplan.id_registro, tabledeleted1,tabla_lotes, tabla_lotes_deleted);

            res.redirect('./crud-ejecucion-diaria');     
            
   
         } else {
            res.redirect('./crud-ejecucion-diaria');     
            
         }
         


   } catch (err) {
      manejo_de_error (err,req,res );
   }
});

//************************ */

//**Fin de rutas para seguimiento de la Produccion */
//******************************************************* */
//**CRUD de Actividades */

router.get('/crudactividades', isLoggedIn, async function(req, res) {
   try {
      res.render('links/crud-actividades');
   } catch (err) {
      manejo_de_error (err,req,res );  
   }   
});
//****************************************************** */
router.get('/listar-actividades', isLoggedIn, async function(req, res) {
   try {
      const consulta = 'SELECT   id_actividad , codigo , descripcion From actividades Where status = "Activa"  ';
      const data = await pool.query (consulta);
      res.send(data);
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//************************************************************ */
router.get('/createactividad', isLoggedIn, async (req,res) => {
   let proxima ='';
   try {
      const rows1 = await pool.query('select codigo from actividades  order by id_actividad desc LIMIT 1');
      if (rows1.length>0) {
         proxima =  parseInt(rows1[0].codigo) + 1;
         proxima = proxima.toString();     
      }
      else {
         proxima = "1";
      }
   
      const newParam = {
         proxima_o: helpers.PadL(proxima,5)
      };
           
            const lista = [{newParam}];
            res.render('links/create-actividad',{lista});  
         } catch (err) {
            manejo_de_error (err,req,res );            
        }
      
});
//********************************************* */

router.post('/createactividad', isLoggedIn, async (req,res) => {
   const { codigo,descripcion, tipo_de_submit, esproductiva_chk, escosteable_chk } = req.body;
      const  newreg = {
         codigo,
         descripcion,
         esproductiva_chk,
         escosteable_chk,
         user_id: req.user.id
   };
  
    if (parseInt(tipo_de_submit) <=0 ) {   
         const sqlinsert = "INSERT INTO actividades (codigo, descripcion,id_usuario, es_productiva, es_costeable) VALUES (?,?,?,?,?) ";
         try { 
             const resultado = await pool.query(sqlinsert,[newreg.codigo, newreg.descripcion, newreg.user_id, newreg.esproductiva_chk, newreg.escosteable_chk] );
             res.redirect('./crudactividades');         
            } catch (err) {
               manejo_de_error (err,req,res );               
         };
      } else {
         res.redirect('./crudactividades');         
      }
});

//****************** */
router.get('/edit-actividad/:id', isLoggedIn, async (req,res) => {   
   try {
            const el_id = req.params.id;
            const registro =  await pool.query('SELECT id_actividad,codigo,descripcion, es_productiva, es_costeable From actividades Where id_actividad = ? ', el_id);
            const newParam = {
               proxima_o: registro[0].codigo,
               descripcion : registro[0].descripcion,
               es_costeable : registro[0].es_costeable,
               es_productiva : registro[0].es_productiva,
               Id_registro : el_id 
            };       
            const lista = [ {newParam}];
            res.render('links/edit-actividad',{lista});  
         } catch (err) {
            manejo_de_error (err,req,res );           
        }
      
});
//**************************************** */
router.post('/edit-actividad', isLoggedIn, async (req,res) => {
   const {codigo, descripcion, tipo_de_submit, id_registro, esproductiva_chk, escosteable_chk} = req.body;
   
   const  newreg = {
        codigo,
        descripcion,
        id_registro,
        esproductiva_chk,
        escosteable_chk,
        user_id: req.user.id
   };

   // console.log(newreg);

    if (parseInt(tipo_de_submit) <=0 ) {   
         try {
            const sqlupdate = "UPDATE actividades SET   codigo = ? , descripcion = ?, es_productiva = ? , es_costeable = ?  where actividades.id_actividad = ?  "; 
            const resultado = await pool.query(sqlupdate,[ newreg.codigo, newreg.descripcion, newreg.esproductiva_chk, newreg.escosteable_chk, newreg.id_registro] );
            res.redirect('./crudactividades');     
            } catch (err) {
               manejo_de_error (err,req,res );            
         };
      } else {
         res.redirect('./crudactividades');              
      }
});



//**FIN de CRUD de Actividades */
//***************************************************** */

//* rutas para  Planificacion
router.post('/aprobar-ordenes', isLoggedIn, async (req,res) => { 
   try {
       const {tabladatos01} = req.body;   

      // console.log('la data seleccionada es : ' + tabladatos01 )    ;
        
       const Ordenes_aprobadas = await helpers.AprobarPlanes(tabladatos01,req.user.id);

       const newParam = {
           rol : req.user.rol,
           ordenes_aprob : Ordenes_aprobadas
       };
  
     const lista = [  {newParam} ];
     res.render('links/list-planes', {lista});      

      } catch (err) {
            manejo_de_error (err,req,res );
       }
      
});


//*************************************** */
router.post('/aprobar-seguimiento-prod', isLoggedIn, async (req,res) => { 
   try {
       const {tabladatos01} = req.body;   

     //  console.log('la data seleccionada es : ' + tabladatos01 )    ;

       const Ordenes_aprobadas = await helpers.Aprobar_Seguimientos_Prod(tabladatos01,req.user.id);

       const newParam = {
           rol : req.user.rol,
           ordenes_aprob : Ordenes_aprobadas
       };
  
     const lista = [  {newParam} ];

     res.render('links/crud-ejecucion', {lista});
     
      } catch (err) {
            manejo_de_error (err,req,res );
       }
      
});

//************************************************************************************** */

router.get('/listar-productos9', isLoggedIn, async function(req, res) {
   try {
      const consulta = 'SELECT id_productos, codigo, descripcion, unidad_medida as medida,  peso FROM productos';
      const data = await pool.query (consulta);
      res.send(data);
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});

//************************************************************************************ */
router.get('/actividadesxarea-plan/:id', isLoggedIn, async (req,res) => {
   try {
      const el_id = helpers.validar_entero( req.params.id);
      let sql = "SELECT departamento_02.id_dpto,  departamento.nombre , departamento_02.id_actividad , actividades.descripcion, actividades.es_productiva as es_productiva1, actividades.es_costeable , sum(actividades.es_productiva + actividades.es_costeable) as es_productiva FROM departamento_02, actividades,departamento  Where   departamento.id_dpto = departamento_02.id_dpto and  departamento_02.id_actividad = actividades.id_actividad and   departamento_02.id_dpto = ?  group by departamento_02.id_dpto,  actividades.id_actividad"; 
      const data = await pool.query(sql, el_id);
      res.send(data);   
   } catch (err) {
      manejo_de_error (err,req,res );
  }
});

//************************************************************************************* */

router.get('/planificacion', isLoggedIn, async (req,res) => {
   var proxima ='';
   const rows1 = await pool.query('select numerodeorden from planificaciones  order by id_plan desc LIMIT 1');
   if (rows1.length>0) {
      proxima =  parseInt('0' + rows1[0].numerodeorden) + 1;
      proxima = proxima.toString();     
   }
   else {
      proxima = "1";
   }

   const newParam = {
      proxima_o: helpers.PadL(proxima,5),
   };
   try {          
            const lista_productos =  await pool.query("SELECT id_productos, descripcion  FROM productos");
            const lista_areas =  await pool.query("SELECT id_dpto, nombre  FROM departamento");
            const lista = [{ lista_areas}, {newParam}, {lista_productos}];
            res.render('links/planificacion',{lista});  
         } catch (err) {
            manejo_de_error (err,req,res );
        }
      
});

//************************************************************************************ */
router.get('/edit-planificacion/:id', isLoggedIn, async (req,res) => {
   
   try {
            const el_id = helpers.validar_entero(req.params.id);
            const registro =  await pool.query('SELECT planificaciones.id_plan, planificaciones.numerodeorden,  DATE_FORMAT(planificaciones.fechainicial, "%Y-%m-%d") as Fechai  ,  DATE_FORMAT(planificaciones.fechafinal, "%Y-%m-%d") as Fechaf,  planificaciones.id_dpto ,  planificaciones.horas_disponibles, departamento.nombre as el_departamento, planificaciones.notas, planificaciones.estado  FROM planificaciones , departamento    Where   planificaciones.id_dpto = departamento.id_dpto  and    planificaciones.id_plan = ? ', el_id);
            const newParam = {
               proxima_o: registro[0].numerodeorden,
               fechaI : registro[0].Fechai,
               fechaF : registro[0].Fechaf,
               horas_disponibles : registro[0].horas_disponibles, 
               id_dpto: registro[0].id_dpto,
               nomb_dpto: registro[0].el_departamento,
               notas : registro[0].notas,
               estado : registro[0].estado,
               nombre_estado : helpers.nombre_estado(registro[0].estado),
               Id_registro : el_id 
            };

            const lista_detalle = await pool.query('SELECT id_plan, id_unico, dia, DATE_FORMAT(fecha, "%Y-%m-%d") as fecha_dia, id_actividad, nombre_actividad, id_producto, nombre_producto,  hora_inicio, hora_final from planificaciones_01  Where id_plan = ?', [el_id]);

            const lista_detalle_02 = await pool.query('SELECT id_plan, id_unico, nro_registro, id_producto, id_actividad, lote, cantidad, filtro  from planificaciones_02  Where id_plan = ?', [el_id]);

            const lista_productos =  await pool.query("SELECT id_productos, descripcion  FROM productos");

            const lista = [  {newParam} , {lista_detalle} , {lista_detalle_02} , {lista_productos} ];
            res.render('links/edit-planificacion',{lista});  
         } catch (err) {
            manejo_de_error (err,req,res );
        }
      
});
//**************************************************************************************** */
router.post('/edit-planificacion', async (req,res) => {
   try {

      const {horas_disponibles,id_registro, tabla_actividades, tabla_lotes,tabledeleted1,notas,tipo_de_submit, tabla_lotes_deleted,status } = req.body;
   
      const  newplan = {
         horas_disponibles : helpers.validar_entero(horas_disponibles),
         id_registro : helpers.validar_entero(id_registro),
         notas,
         status,
         user_id: req.user.id
      };
       if (parseInt(tipo_de_submit) <= 0 ) {   
            const sqlupdate = "UPDATE planificaciones SET horas_disponibles = ? , notas = ?, estado = ?  where planificaciones.id_plan = ?  ";
            const resultado = await pool.query(sqlupdate,[parseFloat('0' + newplan.horas_disponibles),notas,parseInt('0' + newplan.status) ,parseInt('0' + newplan.id_registro)] );

            const exito2 = await helpers.Update_detalles_Planificaciones(tabla_actividades,newplan.id_registro, tabledeleted1,tabla_lotes, tabla_lotes_deleted);

            res.redirect('./planificaciones-general');     
            
   
         } else {
            res.redirect('./planificaciones-general');     
            
         }
         


   } catch (err) {
      manejo_de_error (err,req,res );
   }
});


//************************************************************************************* */

router.post('/planificacion', async (req,res) => {
   try {
      //***** */
      const {numero_p, fecha_desde, fecha_hasta, horas_disponibles,   tipo_de_submit, tabla_actividades, tabla_lotes, area, notas,status } = req.body;
      const  newplan = {
           numero_p,
           fecha_desde,
           fecha_hasta,        
           area,
           notas,
           horas_disponibles,
           status,
           user_id: req.user.id
      };
   
       if (parseInt(tipo_de_submit) <=0 ) {   

            const sqlinsert = "INSERT INTO planificaciones (numerodeorden, fechainicial, fechafinal,  id_usuario, horas_disponibles,id_dpto,notas,estado) VALUES (?,?,?,?,?,?,?,?) ";
             const resultado = await pool.query(sqlinsert,[newplan.numero_p, newplan.fecha_desde, newplan.fecha_hasta,  parseInt('0' + newplan.user_id), parseFloat ('0' + newplan.horas_disponibles),parseInt ('0' + newplan.area), newplan.notas, parseInt('0' + newplan.status)] );
         
             const exito2 = await helpers.InsertDetalle_Plan([resultado][0].insertId, tabla_actividades, tabla_lotes ) ;

             res.redirect('./planificaciones-general');     
           
         } else {
            res.redirect('./planificaciones-general');                 
         }
   
//****** */

   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//**************************************** */
router.get('/lista-planesgeneral', async function(req, res) {
   try {
      const consulta = 'SELECT  planificaciones.id_plan, planificaciones.numerodeorden,  DATE_FORMAT(planificaciones.fechainicial, "%d-%m-%Y") AS Fecha_i,  DATE_FORMAT(planificaciones.fechafinal, "%d-%m-%Y") AS Fecha_f , departamento.nombre as el_departamento, planificaciones.horas_disponibles,planificaciones.estado From planificaciones,departamento  Where  planificaciones.id_dpto = departamento.id_dpto and   planificaciones.status = "Activa"   order by planificaciones.id_plan desc';
      const data = await pool.query (consulta);
      res.send(data);
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});

//***************************** */
router.get('/api-show-programacion/:id', async function(req, res) {
   try {
      const el_id = req.params.id;
      const consulta = "SELECT planificaciones_01.id_plan, planificaciones_01.id_unico, planificaciones_01.dia,  DATE_FORMAT(planificaciones_01.fecha, '%d-%m-%Y') as Fecha_reg, CONCAT_WS(' ' , planificaciones_01.dia, DATE_FORMAT(planificaciones_01.fecha, '%d-%m-%Y') ) as dia_c,  planificaciones_01.nombre_actividad, planificaciones_01.nombre_producto ,  planificaciones_01.hora_inicio,  planificaciones_01.hora_final, timediff(hora_final,hora_inicio) as horas,    planificaciones_02.nro_registro,planificaciones_02.lote, planificaciones_02.cantidad   From planificaciones_01 INNER JOIN planificaciones_02 ON planificaciones_01.id_plan = planificaciones_02.id_plan  AND    planificaciones_01.id_unico = planificaciones_02.id_unico where planificaciones_01.id_plan = ?  UNION  distinct   SELECT planificaciones_01.id_plan, planificaciones_01.id_unico, planificaciones_01.dia,  DATE_FORMAT(planificaciones_01.fecha, '%d-%m-%Y') as Fecha_reg,   CONCAT_WS(' ' , planificaciones_01.dia, DATE_FORMAT(planificaciones_01.fecha, '%d-%m-%Y') ) as dia_c,  planificaciones_01.nombre_actividad,  planificaciones_01.nombre_producto ,   planificaciones_01.hora_inicio, planificaciones_01.hora_final,   timediff(hora_final,hora_inicio) as horas,  '1' AS nro_registro, 'N/A' AS lote, '0' AS cantidad  From planificaciones_01 where planificaciones_01.id_plan = ? AND  planificaciones_01.id_unico not in   ( SELECT  planificaciones_01.id_unico From planificaciones_01   INNER JOIN planificaciones_02 ON planificaciones_01.id_plan = planificaciones_02.id_plan  AND   planificaciones_01.id_unico = planificaciones_02.id_unico where planificaciones_01.id_plan = ? )    order by fecha_reg, id_unico, nro_registro";
      const data = await pool.query (consulta,[parseInt('0'+ el_id),parseInt('0'+ el_id),parseInt('0'+ el_id)] );
      res.send(data);
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//******************************************** */
router.get('/api-show-seguimiento/:id', async function(req, res) {
   try {
      const el_id = req.params.id;
      const consulta = "SELECT  seguimiento_produccion_01.numero_seguimiento  , seguimiento_produccion_01.id_unico , seguimiento_produccion_01.dia, DATE_FORMAT( seguimiento_produccion.fecha_registro, '%d-%m-%Y') as Fecha_reg,  CONCAT_WS(' ' , seguimiento_produccion_01.dia, DATE_FORMAT(seguimiento_produccion.fecha_registro, '%d-%m-%Y') ) as dia_c, seguimiento_produccion_01.nombre_actividad, seguimiento_produccion_01.nombre_producto, seguimiento_produccion_01.hora_inicio,  seguimiento_produccion_01.hora_final, timediff(hora_final,hora_inicio) as horas, seguimiento_produccion_02.nro_lote as nro_registro, seguimiento_produccion_02.lote, seguimiento_produccion_02.cantidad From seguimiento_produccion, seguimiento_produccion_01, seguimiento_produccion_02 where  seguimiento_produccion.numero_seguimiento = seguimiento_produccion_01.numero_seguimiento and  seguimiento_produccion_01.numero_seguimiento = seguimiento_produccion_02.numero_seguimiento AND seguimiento_produccion_01.id_unico = seguimiento_produccion_02.id_unico and seguimiento_produccion_01.numero_seguimiento = ? UNION distinct SELECT seguimiento_produccion_01.numero_seguimiento, seguimiento_produccion_01.id_unico, seguimiento_produccion_01.dia, DATE_FORMAT(seguimiento_produccion.fecha_registro, '%d-%m-%Y') as Fecha_reg, CONCAT_WS(' ' , seguimiento_produccion_01.dia, DATE_FORMAT(seguimiento_produccion.fecha_registro, '%d-%m-%Y') ) as dia_c, seguimiento_produccion_01.nombre_actividad,  seguimiento_produccion_01.nombre_producto, seguimiento_produccion_01.hora_inicio, seguimiento_produccion_01.hora_final, timediff(hora_final,hora_inicio) as horas,  '1' AS nro_registro, 'N/A' AS lote, '0' AS cantidad From seguimiento_produccion, seguimiento_produccion_01 where seguimiento_produccion.numero_seguimiento = seguimiento_produccion_01.numero_seguimiento and  seguimiento_produccion_01.numero_seguimiento = ? AND seguimiento_produccion_01.id_unico not in ( SELECT seguimiento_produccion_01.id_unico From seguimiento_produccion_01 INNER JOIN seguimiento_produccion_02 ON seguimiento_produccion_01.numero_seguimiento = seguimiento_produccion_02.numero_seguimiento AND seguimiento_produccion_01.id_unico = seguimiento_produccion_02.id_unico where seguimiento_produccion_01.numero_seguimiento = ? ) order by fecha_reg, id_unico, nro_registro";
      const data = await pool.query (consulta,[parseInt('0'+ el_id),parseInt('0'+ el_id),parseInt('0'+ el_id)] );
      res.send(data);
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});


//************************************** */
router.get('/show-seguimiento-prod/:id', isLoggedIn, async (req,res) => {  
   try {
      const el_id = helpers.validar_entero(req.params.id);

      const sql = 'Select DATE_FORMAT( seguimiento_produccion.fecha_registro  , "%d-%m-%Y") as fecha_i,  seguimiento_produccion.notas, departamento.nombre as el_departamento  from seguimiento_produccion,departamento  where  seguimiento_produccion.id_dpto = departamento.id_dpto and   seguimiento_produccion.numero_seguimiento = ?'  ;

      const result = await pool.query (sql,[el_id] );

      const newParam = {
         subtitulo : 'Seguimiento del: ' + result[0].fecha_i +  ' Para el area: ' + result[0].el_departamento ,
         msfinal : result[0].notas,
         msheader : 'Seguimiento  Area: ' + result[0].el_departamento + ' del ' + result[0].fecha_i , 
         idreg : el_id
      };
   
      const lista = [ {newParam} ];      
      res.render('links/show-seguimientos', {lista} );

   } catch (err) {
      manejo_de_error (err,req,res );
  }

});

//*************************************** */
router.get('/show-programacion/:id', isLoggedIn, async (req,res) => {  
   try {
      const el_id = helpers.validar_entero(req.params.id);

      const sql = 'Select DATE_FORMAT(planificaciones.fechainicial, "%d-%m-%Y") as fecha_i, DATE_FORMAT(planificaciones.fechafinal, "%d-%m-%Y") as fecha_f, planificaciones.notas, departamento.nombre as el_departamento from planificaciones,departamento where planificaciones.id_dpto = departamento.id_dpto and  planificaciones.id_plan = ?'  ;
      const result = await pool.query (sql,[el_id] );
      const newParam = {
         subtitulo : 'Programación de la Producción desde el: ' + result[0].fecha_i + ' hasta el: ' + result[0].fecha_f  + ' Para el area: ' + result[0].el_departamento ,
         msfinal : result[0].notas,
         msheader : 'Programacion Area: ' + result[0].el_departamento + ' del ' + result[0].fecha_i + ' al ' + result[0].fecha_f , 
         idreg : el_id
      };
   
      const lista = [ {newParam} ];      
      res.render('links/show-programacion', {lista} );

   } catch (err) {
      manejo_de_error (err,req,res );
  }

});
//***************************************************************** */
//***Rutas para el ejecucion de la produccion COFASA*/

router.get('/api-crud-ejecucion', async function(req, res) {
   try {
      const consulta = 'Select LPAD(seguimiento_produccion.numero_seguimiento,5,"0") as numero_seguimiento ,  DATE_FORMAT(seguimiento_produccion.fecha_registro, "%d-%m-%Y")  as fecha,  seguimiento_produccion.numerodeprogramacion, departamento.nombre as el_departamento,  planificaciones.horas_disponibles, seguimiento_produccion.estado  from seguimiento_produccion, departamento, planificaciones   where  seguimiento_produccion.id_dpto = departamento.id_dpto and  seguimiento_produccion.id_planificacion = planificaciones.id_plan and  seguimiento_produccion.estado <= 1 ';
      const data = await pool.query (consulta);
      console.log('lad data: ' + data);
      res.send(data);

   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//********************************************************** */

router.get('/crud-ejecucion-diaria', isLoggedIn, async function(req, res) {
   try {

      const newParam = {
         rol : req.user.rol,
         ordenes_aprob : 0
     };
  
     const lista = [  {newParam} ];

     res.render('links/crud-ejecucion', {lista});
   } catch (err) {
      manejo_de_error (err,req,res );  
   }   
});
//******************************************************************************* */

//***Fin de Rutas de seguimiento de la Produccion */

//********************************** */
router.get('/edit-materiaprimaplan/:id', isLoggedIn, async (req,res) => {
   const el_id = req.params.id;
   try {

      const sql1 = 'SELECT materiaprima.id, materiaprima.descripcion, materiaprima.Unidad from materiaprima order by  materiaprima.id ';
      const lista_materiaprima = await pool.query(sql1);
      
      const lista_detalle = await pool.query('SELECT 0 AS RowId, planificaciones_02.id_materiaprima , materiaprima.descripcion As descripcionMP,  planificaciones_02.cantidad FROM  materiaprima , planificaciones_02 Where planificaciones_02.id_materiaprima = materiaprima.id and  planificaciones_02.id_plan = ? order by planificaciones_02.id_materiaprima', [el_id]);

      const sql4 = 'SELECT planificaciones.numerodeorden as Orden,   DATE_FORMAT(planificaciones.fecharegistro, "%d-%m-%Y")  as Fecha,  productos.descripcion as Producto, planificaciones.cantidad, planificaciones.cantidadkilos As Peso, planificaciones.factor_merma FROM planificaciones, productos Where planificaciones.id_producto = productos.id_productos And  planificaciones.id_plan = ? ';
      const registro = await pool.query(sql4,[el_id] );
     
     
      const newParam = {
         Orden: registro[0].Orden ,
         Fecha : registro[0].Fecha,
         Producto: registro[0].Producto,
         Cantidad: registro[0].cantidad,
         Peso: registro[0].Peso,
         Factor_merma: registro[0].factor_merma,
         idreg : el_id,
      };
   
      const lista = [{lista_materiaprima},  {newParam}, {lista_detalle} ];

      res.render('links/materia-primaplan',{ lista } );

   } catch (err) {
      manejo_de_error (err,req,res );
  }

});
//************************************************* */

router.post('/edit-materiaprimaplan', async (req,res) => {
   try {
         
      const {idregistro , tablamateriaprima, tipo_de_submit } = req.body;
      const  newreg = {
         idregistro
      };
      if (parseInt(tipo_de_submit) <= 0 ) {
            const exito = await helpers.UdateMateriaPrimaPlan(newreg.idregistro,tablamateriaprima);
            req.flash('mensajeok','Materia Prima Actualizada correctamente');
            res.redirect('./planificaciones-general');   
       }
      else {
        res.redirect('./planificaciones-general');   
      }      

   } catch (err) {
      manejo_de_error (err,req,res );
  }
   
});


//******************************** */

router.get('/planificaciones-general', isLoggedIn, async function(req, res) {
   try {
      const newParam = {
          rol : req.user.rol,
          ordenes_aprob : 0
      };
   
      const lista = [  {newParam} ];

      res.render('links/list-planes', {lista});
   } catch (err) {
      manejo_de_error (err,req,res );
   }   

});

//****************************************************************************************** */
router.get('/materiaprima/:id', async function(req, res) {
 const elid = req.params.id;
  try {
         const consulta = "SELECT  formula_01.id_materiaprima , materiaprima.descripcion As descripcionMP, formula_01.porcentaje ,materiaprima.equivalentes  FROM  productos,formulas,formula_01, materiaprima   Where  productos.id_formula = formulas.id_formula and   formulas.id_formula = formula_01.id_formula and   formula_01.id_materiaprima = materiaprima.id and   productos.id_productos = ?  order by formula_01.id_materiaprima";
         const data = await pool.query (consulta,elid);
         res.send(data);
      } catch (err) {
         manejo_de_error (err,req,res );
     }
});

//
router.get('/areas/:id', async function(req, res) {
   const elid = req.params.id;
   try {
          const consulta = "SELECT distinct maquinas.id_maquina, maquinas.descripcion  FROM maquinas, departamento_01  Where maquinas.id_maquina = departamento_01.id_maquina and  maquinas.status = 'Activa'  and departamento_01.id_dpto = ? ";
          const data = await pool.query (consulta,elid);
          res.send(data);
       } catch (err) {
         manejo_de_error (err,req,res );
      }
 
});

//
router.get('/Listaopenturno', isLoggedIn,async function(req, res) {
   try {
      const consulta = 'SELECT produccion_diaria.id_produccion, DATE_FORMAT(produccion_diaria.fecha, "%d-%m-%Y") AS Fecha ,  turnos.horarios as turno, departamento.nombre As Area,   usuarios.fullname  AS supervisor, departamento.tipo_de_costo  FROM produccion_diaria, turnos, departamento, usuarios Where   produccion_diaria.id_turno = turnos.id_turnos and     produccion_diaria.id_dpto = departamento.id_dpto and   produccion_diaria.id_supervisor = usuarios.id   and produccion_diaria.status = "Activo" order by produccion_diaria.id_produccion desc';
      const data = await pool.query (consulta);
      res.send(data);
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//***************************************************************** */
router.get('/producciondiaria', isLoggedIn, async function(req, res) {
   try {
      const sql = "SELECT distinct    DATE_FORMAT(produccion_diaria.fecha, '%d-%m-%Y') AS Fecha  FROM bdproduccion.produccion_diaria where status = 'activo' order by fecha desc"
      const lista_fechas = await pool.query (sql);
      res.render('links/prod-diaria',{lista_fechas});
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});

//********************************************************** */

router.get('/listaplanes', isLoggedIn, async (req,res) => {
   try {
      const sql1 = "SELECT planificaciones.numerodeorden, clientes.nombre, productos.descripcion, planificaciones.fechainicial, planificaciones.fechafinal, planificaciones.cantidad, productos.unidad_medida    FROM planificaciones, clientes, productos    Where    planificaciones.id_cliente = clientes.id_cliente and     planificaciones.id_producto = productos.id_productos     order by  planificaciones.numerodeorden desc";
      const lista_planes = await pool.query(sql1);
      res.render('links/listaplanes',{lista_planes});    
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});


//******rutas PARA REPORTES******************************************* */

/************************Reporte Produccion por area */

router.get('/produccioxarea', async function(req, res) {
   try {
      res.render('links/rep-prodxarea');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});


router.get('/rep-prodxarea/:fecha_i&:fecha_f', isLoggedIn, async (req,res) => {

   const fecha_i =  req.params.fecha_i;
   const fecha_f =  req.params.fecha_f;

   try {
      const sql = 'SELECT produccion_diaria.id_dpto , departamento.nombre As Area , productos.id_productos ,   productos.descripcion As Producto, productos.unidad_medida As unidad,   DATE_FORMAT(produccion_diaria.fecha, "%d-%m-%Y") AS Fecha  ,  sum(produccion_diaria_01.cantidad) As TotalProduccion , sum(produccion_diaria_01.peso) As TotalPeso,  sum(produccion_diaria_01.merma) As TotalMerma FROM produccion_diaria_01, produccion_diaria, departamento, productos, planificaciones Where   produccion_diaria.id_produccion = produccion_diaria_01.id_produccion and    produccion_diaria.id_dpto = departamento.id_dpto and    produccion_diaria_01.orden = planificaciones.numerodeorden and   planificaciones.id_producto = productos.id_productos and   produccion_diaria.status = "Cerrado" and    produccion_diaria.fecha >= ?   and produccion_diaria.fecha<= ?   group by produccion_diaria.id_dpto,  produccion_diaria.fecha , productos.id_productos  order by produccion_diaria.id_dpto,  produccion_diaria.fecha , productos.id_productos '; 
      const data = await pool.query(sql, [fecha_i,fecha_f]);
      res.send(data);

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});

//********************************************************** */

router.get('/rep-prodxproducto/:fecha_i&:fecha_f', isLoggedIn, async (req,res) => {

   const fecha_i =  req.params.fecha_i;
   const fecha_f =  req.params.fecha_f;

   try {
      const sql = 'SELECT   productos.id_productos ,   productos.descripcion,  DATE_FORMAT(produccion_diaria.fecha, "%d-%m-%Y") AS Fecha , sum(produccion_diaria_01.cantidad) As TotalProduccion , sum(produccion_diaria_01.peso) As TotalPeso,  sum(produccion_diaria_01.merma) As TotalMerma FROM produccion_diaria_01, produccion_diaria, departamento, productos, planificaciones Where produccion_diaria.id_produccion = produccion_diaria_01.id_produccion and  produccion_diaria.id_dpto = departamento.id_dpto and  produccion_diaria_01.orden = planificaciones.numerodeorden and  planificaciones.id_producto = productos.id_productos and  produccion_diaria.fecha >= ?  and produccion_diaria.fecha<=  ? and  produccion_diaria.status = "Cerrado" group by   productos.id_productos ,   produccion_diaria.fecha order by   productos.id_productos , produccion_diaria.fecha'; 
      const data = await pool.query(sql, [fecha_i,fecha_f]);
      res.send(data);

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});


router.get('/produccioxproducto', async function(req, res) {
   try {
      res.render('links/rep-prodxproducto');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});


//****************************
router.get('/produccioxoperador', async function(req, res) {
   try {
      res.render('links/rep-prodxoperador');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});

router.get('/rep-prodxoperador/:fecha_i&:fecha_f', isLoggedIn, async (req,res) => {

   const fecha_i =  req.params.fecha_i;
   const fecha_f =  req.params.fecha_f;

   try {
      const sql = 'SELECT   produccion_diaria_01.nombre_operador ,  DATE_FORMAT(produccion_diaria.fecha, "%d-%m-%Y") AS Fecha,  productos.id_productos ,   productos.descripcion as producto ,    sum(produccion_diaria_01.cantidad) As TotalProduccion , sum(produccion_diaria_01.peso) As TotalPeso,   sum(produccion_diaria_01.merma) As TotalMerma ,  maquinas.id_maquina, maquinas.descripcion As descripcion_maquina FROM produccion_diaria_01, produccion_diaria,  productos, planificaciones,maquinas Where    produccion_diaria.id_produccion = produccion_diaria_01.id_produccion and   produccion_diaria_01.orden = planificaciones.numerodeorden and    produccion_diaria_01.id_maquina = maquinas.id_maquina and  planificaciones.id_producto = productos.id_productos and    produccion_diaria.fecha >= ?  and  produccion_diaria.fecha<= ?  and    produccion_diaria.status = "Cerrado"   group by   produccion_diaria_01.nombre_operador, produccion_diaria.fecha   , productos.id_productos    order by   produccion_diaria_01.nombre_operador, produccion_diaria.fecha   , productos.id_productos'; 
      const data = await pool.query(sql, [fecha_i,fecha_f]);
      res.send(data);

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});

//******************************************************* */
router.get('/produccioxorden', async function(req, res) {
   try {
      res.render('links/rep-prodxorden');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//**************************************************************************************** */
router.get('/rep-prodxorden/:fecha_i&:fecha_f', isLoggedIn, async (req,res) => {

   const fecha_i =  req.params.fecha_i;
   const fecha_f =  req.params.fecha_f;

   try {
      const sql = 'SELECT   concat_ws( " ", produccion_diaria_01.orden, productos.descripcion ) as orden , productos.descripcion As Producto, productos.unidad_medida As unidad, planificaciones.cantidad As Cantidad_Planificada, planificaciones.cantidadkilos as Peso_Planificado,  (planificaciones.cantidadkilos * (planificaciones.factor_merma/100)) As Merma_planificada,  sum(produccion_diaria_01.cantidad) As Produccion_Ejecutada ,  sum(produccion_diaria_01.peso) As Peso_ejecutado,     sum(produccion_diaria_01.merma)  As Merma_ejecutada,  ((sum(produccion_diaria_01.cantidad)/planificaciones.cantidad) * 100) As Porcetaje_Ejecutado,   ((sum(produccion_diaria_01.peso)/planificaciones.cantidadkilos) * 100) AS Porcentaje_Peso_Ejecutado,  ( (sum(produccion_diaria_01.merma)/(planificaciones.cantidadkilos * (planificaciones.factor_merma/100))) * 100) As Porcentaje_merma_ejecutado  FROM produccion_diaria_01, produccion_diaria,  productos, planificaciones  Where    produccion_diaria.id_produccion = produccion_diaria_01.id_produccion and    produccion_diaria_01.orden = planificaciones.numerodeorden and    planificaciones.id_producto = productos.id_productos and   produccion_diaria.status = "Cerrado" and    produccion_diaria.fecha >= ?  and  produccion_diaria.fecha<= ?    group by produccion_diaria_01.orden,   productos.id_productos   order by produccion_diaria_01.orden,  produccion_diaria.fecha , productos.id_productos '; 
      const data = await pool.query(sql, [fecha_i,fecha_f]);
      res.send(data);

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});
//************************************************************* */

router.get('/rep-prodxmaquina/:fecha_i&:fecha_f', isLoggedIn, async (req,res) => {

   const fecha_i =  req.params.fecha_i;
   const fecha_f =  req.params.fecha_f;

   try {
      const sql = 'SELECT produccion_diaria.id_dpto , departamento.nombre as departamento,   concat_ws( " ", produccion_diaria_01.id_maquina , maquinas.descripcion ) as la_maquina ,  productos.descripcion As Producto,   productos.unidad_medida As unidad, planificaciones.cantidad As Cantidad_Planificada,   planificaciones.cantidadkilos as Peso_Planificado,   (planificaciones.cantidadkilos * (planificaciones.factor_merma/100)) As Merma_planificada,  sum(produccion_diaria_01.cantidad) As Produccion_Ejecutada ,  sum(produccion_diaria_01.peso) As Peso_ejecutado,  sum(produccion_diaria_01.merma)  As Merma_ejecutada,   ((sum(produccion_diaria_01.cantidad)/planificaciones.cantidad) * 100) As Porcetaje_Ejecutado,   ((sum(produccion_diaria_01.peso)/planificaciones.cantidadkilos) * 100) AS Porcentaje_Peso_Ejecutado,   ( (sum(produccion_diaria_01.merma)/(planificaciones.cantidadkilos * (planificaciones.factor_merma/100))) * 100) As Porcentaje_merma_ejecutado    FROM produccion_diaria_01, produccion_diaria,  productos, planificaciones, maquinas, departamento  Where    produccion_diaria.id_produccion = produccion_diaria_01.id_produccion and    produccion_diaria.id_dpto = departamento.id_dpto and   produccion_diaria_01.orden = planificaciones.numerodeorden and      planificaciones.id_producto = productos.id_productos and    produccion_diaria_01.id_maquina = maquinas.id_maquina and   produccion_diaria.status = "Cerrado" and    produccion_diaria.fecha >= ?  and  produccion_diaria.fecha<= ?   group by produccion_diaria.id_dpto, produccion_diaria_01.id_maquina,   maquinas.descripcion, productos.descripcion   order by produccion_diaria.id_dpto, maquinas.descripcion,   productos.descripcion '; 
      const data = await pool.query(sql, [fecha_i,fecha_f]);
     // console.log(data)
      res.send(data);
   } catch (err) {    
      manejo_de_error (err,req,res );
  }
});

router.get('/rep-prodxmaquina', async function(req, res) {
   try {
      res.render('links/rep-produccionxmaquina');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});


//************************************************************ */

router.get('/rep-consumomp/:fecha_i&:fecha_f', isLoggedIn, async (req,res) => {

   const fecha_i =  req.params.fecha_i;
   const fecha_f =  req.params.fecha_f;

   try {
      const sql = 'SELECT materiaprima.codigo , materiaprima.descripcion As MateriaPrima , materiaprima.Unidad, DATE_FORMAT(produccion_diaria.fecha, "%d-%m-%Y") AS fecha, Sum(produccion_diaria_02.Cantidad)  As Total_Consumo  From materiaprima, produccion_diaria, produccion_diaria_02  Where  produccion_diaria.id_produccion = produccion_diaria_02.id_produccion and   produccion_diaria_02.id_materiaprima = materiaprima.id and   produccion_diaria.status = "Cerrado" and produccion_diaria.fecha >= ?  and produccion_diaria.fecha <= ? group by materiaprima.codigo, produccion_diaria.fecha   order by materiaprima.codigo, produccion_diaria.fecha'; 
      const data = await pool.query(sql, [fecha_i,fecha_f]);
      res.send(data);

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});
//************************************************************************ */
router.get('/repconsumomp', async function(req, res) {
   try {
      res.render('links/rep-consumomp');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});

//**************************************************************************** */
router.get('/rep-requerimientoMp/:fecha_i&:fecha_f', isLoggedIn, async (req,res) => {

   const fecha_i =  req.params.fecha_i;
   const fecha_f =  req.params.fecha_f;

   try {
      const sql = 'SELECT planificaciones.numerodeorden as Nro_orden , productos.descripcion as producto, productos.unidad_medida as medida_producto , concat_ws( " ", "orden : ",  planificaciones.numerodeorden, "Producto : " ,  productos.descripcion , " Cliente : " , clientes.nombre ) as orden ,  planificaciones_02.id_materiaprima, materiaprima.codigo , materiaprima.descripcion , materiaprima.unidad,   planificaciones_02.cantidad, planificaciones.id_dpto , departamento.nombre as nombre_area, concat_ws( " ", "Materia Prima  : ",  materiaprima.codigo, " Descripción : " ,  materiaprima.descripcion , "  ", materiaprima.unidad  ) as Des_MateriaPrima   FROM planificaciones, planificaciones_02, materiaprima,productos, clientes, departamento  Where   planificaciones.id_producto = productos.id_productos and   planificaciones.id_cliente = clientes.id_cliente and   planificaciones.id_plan = planificaciones_02.id_plan and  planificaciones.id_dpto = departamento.id_dpto and  planificaciones_02.id_materiaprima = materiaprima.id and  planificaciones_02.cantidad > 0 and    planificaciones.fechainicial >= ? and  planificaciones.fechafinal <= ? order by  planificaciones.id_plan, materiaprima.codigo  '; 
      const data = await pool.query(sql, [fecha_i,fecha_f]);
      res.send(data);

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});

router.get('/reprequerimientomp', async function(req, res) {
   try {
      res.render('links/rep-requerimientoMp');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//************************************************************ */
//* rutas para el crud de Areas

router.get('/listar-areas', isLoggedIn, async (req,res) => {

   try {
      const sql = 'SELECT  id_dpto As ID , nombre from departamento'; 
      const data = await pool.query(sql);
      res.send(data);

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});
//****************************************** */
router.get('/createareas', isLoggedIn, async (req,res) => {

   try {
      const lista_maquinas =  await pool.query("SELECT id_maquina, descripcion,codigo FROM maquinas  Where status = 'Activa' order by id_maquina");
   
      const lista = [{ lista_maquinas }];

      res.render('links/create-areas',{ lista });
   } catch (err) {
      manejo_de_error (err,req,res );
  }

});
//************* */

router.post('/createareas', async (req,res) => {
   try {       
      const {descripcion , tablamaquinas, tipo_costos, comisiondolar, comisionbs ,tipo_de_submit } = req.body;
      
      if (parseInt(tipo_de_submit) <= 0 ) {
         console.log(comisiondolar)
           const resultado =  await pool.query("INSERT INTO departamento (nombre, tipo_de_costo, comision_dolar, comision_bs ) VALUES (?,?,?,?) ", [descripcion,tipo_costos,comisiondolar,comisionbs]);
         const id_insertado = [resultado][0].insertId;
         const exito1 = await helpers.InsertarMaquinasDearea(id_insertado,tablamaquinas);
         res.redirect('./crudareas');   
       }
      else {
         res.redirect('./crudareas'); 
      }      

   } catch (err) {
      manejo_de_error (err,req,res );
  }
   
});
//*********************************************** */

router.get('/area-actividad/:id', isLoggedIn, async (req,res) => {
   const el_id = req.params.id;
   try {
      const lista_actividad =  await pool.query("SELECT id_actividad, codigo,descripcion FROM actividades  Where status = 'Activa' order by id_actividad");
      const lista_detalle = await pool.query ("SELECT departamento_02.id_dpto,departamento_02.id_actividad , actividades.descripcion  FROM departamento_02, actividades  Where    departamento_02.id_actividad = actividades.id_actividad and   departamento_02.id_dpto = ?",el_id )     
      const sql1 = "Select id_dpto,nombre From departamento Where id_dpto= ?";
      registro = await pool.query(sql1,el_id);
      const newParam = {
         id_dpto: registro[0].id_dpto ,
         descripcion : registro[0].nombre,
         idreg : el_id,
      }; 
      const lista = [{ lista_actividad },  {newParam}, {lista_detalle} ];
      res.render('links/area-actividad',{ lista } );
   } catch (err) {
      manejo_de_error (err,req,res );
  }


});
//*************************************************** */
router.post('/area-actividad', isLoggedIn, async (req,res) => {

   try {
      const {descripcion, Id_registro, tablaactividades, tipo_de_submit } = req.body;
      const  newreg = {
         descripcion,
         Id_registro
      };
      if (parseInt(tipo_de_submit) <= 0 ) {
            // eliminas los registros de  la  tabla detalles de departamentos
            const sqldelete = "DELETE FROM departamento_02   Where id_dpto = ? ";
            const resultado = await pool.query(sqldelete,[ parseInt (newreg.Id_registro)] );
            // construye el detalle de actividades nuevamente
            const res_detalle = await helpers.InsertarActividadesDearea(parseInt (newreg.Id_registro),tablaactividades );
            req.flash('mensajeok','Actividades Actualizadas correctamente');
            res.redirect('./crudareas');
       }
      else {
         res.redirect('./crudareas');
      }      

   } catch (err) {
      manejo_de_error (err,req,res );
  }



});

//************************************************** */

router.get('/edit-areas/:id', isLoggedIn, async (req,res) => {
   const el_id = req.params.id;
   try {
      const lista_maquinas =  await pool.query("SELECT id_maquina, descripcion,codigo FROM maquinas  Where status = 'Activa' order by id_maquina");
      const lista_detalle = await pool.query ("SELECT departamento_01.id_maquina, maquinas.descripcion   FROM departamento_01, maquinas  Where  departamento_01.id_maquina = maquinas.id_maquina and  departamento_01.id_dpto = ? ",el_id )     
      const sql1 = "Select id_dpto,nombre, tipo_de_costo, comision_dolar, comision_bs   From departamento Where id_dpto= ?";
      registro = await pool.query(sql1,el_id);
      const newParam = {
         id_dpto: registro[0].id_dpto ,
         descripcion : registro[0].nombre,
         tipo_de_costo : registro[0].tipo_de_costo,
         comision_dolar : registro[0].comision_dolar,
         comision_bs : registro[0].comision_bs,
         idreg : el_id,
      }; 
      const lista = [{ lista_maquinas },  {newParam}, {lista_detalle} ];
      res.render('links/edit-areas',{ lista } );
   } catch (err) {
      manejo_de_error (err,req,res );
  }


});
//**************************/
router.post('/edit-areas', isLoggedIn, async (req,res) => {

   try {
      const {descripcion, Id_registro, tablamaquinas, tipo_costos, comisiondolar, comisionbs, tipo_de_submit } = req.body;
      const  newreg = {
         descripcion,
         Id_registro
      };

      if (parseInt(tipo_de_submit) <= 0 ) {
            const sqlupdate = "UPDATE departamento SET  nombre = ?,  tipo_de_costo = ?, comision_dolar = ?, comision_bs = ?     Where id_dpto = ? ";
            const resultado = await pool.query(sqlupdate,[ descripcion,  tipo_costos , comisiondolar , comisionbs,  parseInt (newreg.Id_registro)] );
            // eliminas los registros de  la  tabla detalles de departamentos
            const borrar = await helpers.DeletedetalleDpto(parseInt (newreg.Id_registro));
            // construye el detalle de departamentos nuevamente
            const res_detalle = await helpers.InsertarMaquinasDearea(parseInt (newreg.Id_registro),tablamaquinas );
            res.redirect('./crudareas');
       }
      else {
         res.redirect('./crudareas');
      }      

   } catch (err) {
      manejo_de_error (err,req,res );
  }



});

//************************ */
router.get('/crudareas', async function(req, res) {
   try {
      res.render('links/crud-areas');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});



//************************************************************ */
//* rutas para el crud de Formulas

router.get('/crudformulas', async function(req, res) {
   try {
      res.render('links/crud-formulas');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});

//***************************************** */
router.get('/listar-formulas', isLoggedIn, async (req,res) => {

   try {
      const sql = 'SELECT  id_formula As ID , codigo, descripcion from formulas'; 
      const data = await pool.query(sql);
      res.send(data);

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});

//***************************************

router.get('/createformulas', isLoggedIn, async (req,res) => {

   try {
      const sql1 = 'SELECT materiaprima.id, materiaprima.descripcion, materiaprima.Unidad from materiaprima order by  materiaprima.id ';
      const lista_materiaprima = await pool.query(sql1);
      const lista = [{ lista_materiaprima }];
      res.render('links/create-formulas',{ lista });

   } catch (err) {
      manejo_de_error (err,req,res );
  }

});

//****************************************************** */

router.post('/createformulas', async (req,res) => {
   try {       
      const { idcodigo , descripcion , tablaMp, usos, tipo_de_submit } = req.body;
     // console.log(tablaMp)
      if (parseInt(tipo_de_submit) <= 0 ) {
        const resultado =  await pool.query("INSERT INTO formulas (codigo,descripcion,notas) VALUES (?,?,?) ", [idcodigo, descripcion,usos] );
        const id_insertado = [resultado][0].insertId;
        const exito1 = await helpers.InsertarMpdeFormulas(id_insertado,tablaMp);
         res.redirect('./crudformulas');   
       }
      else {
         res.redirect('./crudformulas'); 
      }      

   } catch (err) {
      manejo_de_error (err,req,res );
  }   
});
//****************************************************** */

router.get('/edit-formulas/:id', isLoggedIn, async (req,res) => {
   const el_id = req.params.id;
   try {
      const sql1 = 'SELECT materiaprima.id, materiaprima.descripcion, materiaprima.Unidad from materiaprima order by  materiaprima.id ';
      const lista_materiaprima = await pool.query(sql1);

      const lista_detalle = await pool.query ("SELECT formula_01.id_materiaprima , materiaprima.descripcion , formula_01.porcentaje  FROM formula_01, materiaprima  Where  formula_01.id_materiaprima = materiaprima.id and  formula_01.id_formula = ? ",el_id )     

      const sql2 = "SELECT codigo, descripcion, notas FROM formulas where  id_formula = ?";
      registro = await pool.query(sql2,el_id);

      const newParam = {
         id_formula: el_id ,
         codigo : registro[0].codigo,
         descripcion : registro[0].descripcion,
         notas :  registro[0].notas,
         idreg : el_id,
      }; 
      const lista = [{ lista_materiaprima  },  {newParam}, {lista_detalle} ];
      res.render('links/edit-formulas',{ lista } );
   } catch (err) {
      manejo_de_error (err,req,res );
   }
  });

//****************************************************** */

router.post('/edit-formulas', isLoggedIn, async (req,res) => {

   try {
      const {idcodigo, descripcion, Id_registro, tablaMp, usos,  tipo_de_submit } = req.body;
      const  newreg = {
         idcodigo,
         descripcion,
         usos,
         Id_registro
      };
      console.log(tablaMp);
      if (parseInt(tipo_de_submit) <= 0 ) {
            const sqlupdate = "UPDATE formulas SET  codigo = ?, descripcion = ?, notas = ?    Where id_formula = ? ";
            const resultado = await pool.query(sqlupdate,[ newreg.idcodigo  ,  newreg.descripcion, newreg.usos ,  parseInt (newreg.Id_registro)] );
            // eliminas los registros de  la  tabla detalles de formulas
            const borrar = await helpers.Deletedetalleformula(parseInt (newreg.Id_registro));
            // construye el detalle de formulas nuevamente
            const res_detalle = await helpers.InsertarMpdeFormulas(parseInt (newreg.Id_registro),tablaMp );
           // req.flash('mensajeok','Turno Actualizado correctamente');
            res.redirect('./crudformulas');
       }
      else {
         res.redirect('./crudformulas');
      }      

   } catch (err) {
      manejo_de_error (err,req,res );
  }



});
//******************************************************** */
/** Rutas para CRUD de grupos */
router.get('/crudgrupos', async function(req, res) {
   try {
      res.render('links/crud-grupos');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});

//***************************************** */
router.get('/listar-grupos', isLoggedIn, async (req,res) => {

   try {
      const sql = 'SELECT  id_grupo as ID , descripcion from grupos'; 
      const data = await pool.query(sql);
      res.send(data);

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});

//***************************************

router.get('/creategrupos', isLoggedIn, async (req,res) => {

   try {
      const lista_trabajadores =  await pool.query("SELECT id_trabajador,   concat_ws(' ', nombre, apellido ) as persona  FROM trabajadores   WHERE    status ='Activo'");
      const lista = [{ lista_trabajadores }];
      res.render('links/create-grupos',{ lista });
   } catch (err) {
      manejo_de_error (err,req,res );
  }

});

//****************************************************** */

router.post('/creategrupos', async (req,res) => {
   try {       
      const { descripcion , tablaTrabajadores, tipo_de_submit } = req.body;
      if (parseInt(tipo_de_submit) <= 0 ) {
        const resultado =  await pool.query("INSERT INTO grupos (descripcion) VALUES (?) ", [descripcion] );
        const id_insertado = [resultado][0].insertId;
        const exito1 = await helpers.InsertarTrabdeGRupos(id_insertado,tablaTrabajadores);
         res.redirect('./crudgrupos');   
       }
      else {
         res.redirect('./crudgrupos'); 
      }      

   } catch (err) {
      manejo_de_error (err,req,res );
  }   
});

//****************************************************** */

router.get('/edit-grupos/:id', isLoggedIn, async (req,res) => {
   const el_id = req.params.id;
   try {
      const lista_trabajadores =  await pool.query("SELECT id_trabajador,   concat_ws(' ', nombre, apellido ) as persona  FROM trabajadores   WHERE    status ='Activo'");
      
      const lista_detalle = await pool.query ("SELECT grupos_01.id_grupo, grupos_01.id_trabajador,  concat_ws(' ', trabajadores.nombre, trabajadores.apellido ) as persona, grupos_01.rol FROM grupos_01, trabajadores Where grupos_01.id_trabajador = trabajadores.id_trabajador and  grupos_01.id_grupo = ? ",el_id )     

      const sql2 = "SELECT descripcion FROM grupos where  id_grupo = ?";
      registro = await pool.query(sql2,el_id);

      const newParam = {
         id_grupo: el_id ,
         descripcion : registro[0].descripcion,
         idreg : el_id,
      }; 
      const lista = [{ lista_trabajadores },  {newParam}, {lista_detalle} ];
      res.render('links/edit-grupos',{ lista } );
   } catch (err) {
      manejo_de_error (err,req,res );
   }
  });

//****************************************************** */

router.post('/edit-grupos', isLoggedIn, async (req,res) => {

   try {
      const {descripcion, Id_registro, tablaTrabajadores, tipo_de_submit } = req.body;
      const  newreg = {
         descripcion,
         Id_registro
      };
      if (parseInt(tipo_de_submit) <= 0 ) {
            const sqlupdate = "UPDATE grupos SET  descripcion = ?    Where id_grupo = ? ";
            const resultado = await pool.query(sqlupdate,[ newreg.descripcion, parseInt (newreg.Id_registro)] );
            // eliminas los registros de  la  tabla detalles de formulas
            const borrar = await helpers.Deletedetallegrupos(parseInt (newreg.Id_registro));
            // construye el detalle de grupos nuevamente
            const res_detalle = await helpers.InsertarTrabdeGRupos(parseInt (newreg.Id_registro),tablaTrabajadores );
            req.flash('mensajeok','Grupo Actualizado correctamente');
            res.redirect('./crudgrupos');
       }
      else {
         res.redirect('./crudgrupos');
      }      

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});
//**********CRUD DE LA TABLA MATERIA PRIMA */
router.get('/listar-materiaprima1', isLoggedIn, async function(req, res) {
   try {
      const consulta = 'SELECT id, codigo, descripcion, unidad FROM materiaprima';
      const data = await pool.query (consulta);
      res.send(data);
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//******************************************************** */

router.get('/mostrar-crudmateriaprima', async function(req, res) {
   try {
      res.render('links/crud-materiaprima');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//*********************************************************** */
router.get('/createmateriaprima', async function(req, res) {
   try {
      res.render('links/create-materiaprima');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//*************************************************** */
router.post('/createmateriaprima', isLoggedIn, async (req,res) => {
   try {
      const {codigo, descripcion, unidad, costo, tipo_de_submit } = req.body;
      const  newreg = {
         codigo, 
         descripcion,
         unidad,
         costo
      };
      if (parseInt(tipo_de_submit) <= 0 ) {
            const sql = "INSERT INTO materiaprima (codigo,descripcion,unidad,costo ) VALUES (?,?,?,?)";
            const resultado = await pool.query(sql,[newreg.codigo, newreg.descripcion, newreg.unidad,  parseFloat(newreg.costo)  ] );
            res.redirect('./mostrar-crudmateriaprima');
       }
      else {
         res.redirect('./mostrar-crudmateriaprima');
      }      
   } catch (err) {
      manejo_de_error (err,req,res );
  }
});
//********************************************* */
router.get('/edit-materiaprima/:id', isLoggedIn, async (req,res) => {
   const el_id = req.params.id;
   try {
      const sql2 = "SELECT id, codigo, descripcion, unidad, costo   FROM materiaprima  Where  id = ?";
      registro = await pool.query(sql2,el_id);

      const newParam = {
         id_mp: el_id ,
         codigo : registro[0].codigo,
         descripcion : registro[0].descripcion,
         unidad : registro[0].unidad,
         costo: registro[0].costo
      }; 
      const lista = [{newParam} ];
      res.render('links/edit-materiaprima',{ lista } );
   } catch (err) {
      manejo_de_error (err,req,res );
   }
  });
//********************************************************************** */
router.post('/edit-materiaprima', isLoggedIn, async (req,res) => {

   try {
      const { Id_registro,codigo, descripcion, unidad, costo, tipo_de_submit } = req.body;
      const  newreg = {
         Id_registro :  helpers.validar_entero(Id_registro),
         codigo, 
         descripcion,
         unidad,
         costo : helpers.validar_decimal(costo)
      };

      if (parseInt(tipo_de_submit) <= 0 ) {
            const sqlupdate = "UPDATE materiaprima SET  codigo = ? , descripcion = ?, unidad = ? , costo = ?  Where  id = ? ";
            const resultado = await pool.query(sqlupdate,[ newreg.codigo,newreg.descripcion, newreg.unidad,  newreg.costo , newreg.Id_registro   ]  );

            res.redirect('./mostrar-crudmateriaprima');
       }
      else {
           res.redirect('./mostrar-crudmateriaprima');
      }      

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});


//********CRUD DE LA TABLA PRODUCTOS */

router.get('/listar-productos2', isLoggedIn, async function(req, res) {
   try {
      const consulta = 'SELECT id_productos, codigo, descripcion, unidad_medida FROM productos';
      const data = await pool.query (consulta);
      res.send(data);
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//**************************************** */
router.get('/mostrar-crudproductos', async function(req, res) {
   try {
      res.render('links/crud-productos');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//*********************************** */

router.get('/createproductos', async function(req, res) {
   try {

      const lista_formulas = await pool.query ("SELECT id_formula, descripcion FROM formulas" );
      const lista_tipoproducto = await pool.query ("SELECT id_tipo, descripcion FROM tipoproducto" );
      const lista = [{ lista_formulas }, {lista_tipoproducto}];
      res.render('links/create-productos',{lista});
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//***************************************************** */
router.post('/createproductos', isLoggedIn, async (req,res) => {

  try {
   let la_imagen = "";  
   const {codigo,  descripcion, unidad, subproducto, formula, comisiondolar, comisionbs, tipo_producto,peso , subrproducto_chk ,tipo_de_submit,  unidadesxempaque, empaquexestuche, estuche_bulto } = req.body;
   const  newreg = {
      codigo, 
      descripcion,
      unidad,
      subproducto, 
      formula, 
      tipo_producto,
      comisiondolar, 
      comisionbs, 
      peso,
      unidadesxempaque : helpers.validar_entero(unidadesxempaque),
      empaquexestuche : helpers.validar_entero(empaquexestuche),
      estuche_bulto : helpers.validar_entero(estuche_bulto),
      subrproducto_chk
   };
   
  if(typeof req.file === 'undefined'){
     la_imagen = '';
    }else {
    la_imagen = req.file.filename;
    }
  
   if (parseInt(tipo_de_submit) <= 0 ) {
        const sql = "INSERT INTO productos (codigo,descripcion,unidad_medida,es_subproducto,id_formula, comision_dolar, comision_bs, peso, imagen, tipo_producto,unidadesxempaque,empaquexestuche,estuche_bulto  ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        const resultado = await pool.query(sql,[ newreg.codigo,newreg.descripcion, newreg.unidad,  parseInt(newreg.subrproducto_chk) , parseInt(newreg.formula),  parseFloat('0' + newreg.comisiondolar) , parseFloat('0' + newreg.comisionbs) , parseFloat('0' + newreg.peso), la_imagen, parseInt( '0' +  newreg.tipo_producto), newreg.unidadesxempaque, newreg.empaquexestuche, newreg.estuche_bulto   ] );
         if (newreg.subrproducto_chk == 1 ) {
            const sql2 = "INSERT INTO materiaprima (codigo,descripcion,unidad) VALUES (?,?,?)";
            const resultado2 = await pool.query(sql2,[ newreg.codigo,newreg.descripcion, newreg.unidad ] );  
         }
         res.redirect('./mostrar-crudproductos');
    }
   else {
      res.redirect('./mostrar-crudproductos');
   }      
} catch (err) {
   manejo_de_error (err,req,res );
}


});
//**************************************************** */
router.get('/edit-productos/:id', isLoggedIn, async (req,res) => {
   const el_id = req.params.id;
   let sqlf = "";
   try {
      const sql2 = "SELECT id_productos, codigo, descripcion, unidad_medida, es_subproducto, id_formula, comision_dolar, comision_bs,  peso, imagen, tipo_producto, unidadesxempaque, empaquexestuche, estuche_bulto  FROM productos  Where  id_productos = ?";
      registro = await pool.query(sql2,el_id);

      const newParam = {
         id_producto: el_id ,
         codigo : registro[0].codigo,
         descripcion : registro[0].descripcion,
         unidad : registro[0].unidad_medida,
         es_subproducto : registro[0].es_subproducto,
         id_formula : registro[0].id_formula,
         descripcion_formula : await helpers.des_formula(registro[0].id_formula),
         id_tipo_producto : registro[0].tipo_producto,
         descripcion_tipoP : await helpers.des_tipo_producto(registro[0].tipo_producto),
         comision_dolar : registro[0].comision_dolar,
         comision_bs : registro[0].comision_bs,
         peso : registro[0].peso,
         unidadesxempaque : registro[0].unidadesxempaque,
         empaquexestuche : registro[0].empaquexestuche,
         estuche_bulto : registro[0].estuche_bulto,
         imagen : '/uploads/' +  registro[0].imagen,
         originalnameimg : registro[0].imagen
      }; 
      //console.log(newParam.imagen);
      sqlf = "SELECT id_formula, descripcion FROM formulas Where  id_formula <> ?" ; 
      const lista_formulas = await pool.query (sqlf, newParam.id_formula );
      const lista_tipoproducto = await pool.query ("SELECT id_tipo, descripcion FROM tipoproducto Where id_tipo <> ?" , [newParam.id_tipo_producto] );

      const lista = [{ lista_formulas },  {newParam},  {lista_tipoproducto}];
      res.render('links/edit-productos',{ lista } );
   } catch (err) {
      manejo_de_error (err,req,res );
   }
  });
//********************************************************* */
router.post('/edit-productos', isLoggedIn, async (req,res) => {

   try {
      const { Id_registro,codigo, imagen1, imagen2, descripcion, unidad, subproducto, formula, comisiondolar, comisionbs, peso , subrproducto_chk ,tipo_de_submit, tipo_producto, unidadesxempaque, empaquexestuche, estuche_bulto } = req.body;
      const  newreg = {
         Id_registro,
         codigo, 
         descripcion,
         unidad,
         subproducto, 
         formula, 
         comisiondolar, 
         comisionbs, 
         peso,
         tipo_producto,
         imagen1,
         unidadesxempaque : helpers.validar_entero(unidadesxempaque),
         empaquexestuche : helpers.validar_entero(empaquexestuche),
         estuche_bulto : helpers.validar_entero(estuche_bulto),
         subrproducto_chk
      };

      if(typeof req.file === 'undefined'){
         la_imagen = '';
        }else {
        la_imagen = req.file.filename;
      }
      
      if (parseInt(tipo_de_submit) <= 0 ) {

         if (la_imagen.trim().length > 0) {
            var img_original = imagen2 + '';
            if (img_original.trim().length > 0) {
                  var file_to_delete = path.join(__dirname, '..', 'public/uploads/', img_original.trim())
                  if (fs.existsSync(file_to_delete)) {
                     fs.unlinkSync(file_to_delete);  
                  }
            }
           }else {
            la_imagen = imagen2;
           }
            const sqlupdate = "UPDATE productos SET  codigo = ? , descripcion = ?, unidad_medida = ? , es_subproducto = ? , id_formula = ?,  comision_dolar = ?,  comision_bs = ? ,  peso = ?, imagen = ? , tipo_producto = ?,  unidadesxempaque = ?,  empaquexestuche = ?,  estuche_bulto = ?   Where  id_productos = ? ";
            const resultado = await pool.query(sqlupdate,[ newreg.codigo,newreg.descripcion, newreg.unidad,  parseInt(newreg.subrproducto_chk) , parseInt(newreg.formula),  parseFloat('0' + newreg.comisiondolar) , parseFloat('0' + newreg.comisionbs) , parseFloat('0' + newreg.peso), la_imagen.trim() , parseInt(newreg.tipo_producto) ,  newreg.unidadesxempaque,  newreg.empaquexestuche , newreg.estuche_bulto , parseInt(newreg.Id_registro)   ]  );
            res.redirect('./mostrar-crudproductos');
       }
      else {
           res.redirect('./mostrar-crudproductos');
      }      

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});
//****************************** */
//*Rutas para el CRUD de plantillas
router.get('/api-listarplantillas', isLoggedIn, async (req, res) => {
   try {
      const consulta = 'SELECT id, descripcion FROM plantillaconsumo';
      const data = await pool.query (consulta);
      res.send(data);
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//******************************* */
router.get('/mostrar-plantillaconsumo', async (req, res) => {
      try {
         res.render('links/crud-plantillas');
      } catch (err) {
         manejo_de_error (err,req,res );
      }
   });

//************************************** */
router.get('/createplantilla', async (req, res) => {
      try {
         res.render('links/create-plantillas');
      } catch (err) {
         manejo_de_error (err,req,res );
      }
   });
//******************************** */
router.post('/createplantilla', async (req, res) => {
   try {
      const { descripcion, tabladeeliminados, tablamateriaprima,observaciones,  tipo_de_submit } = req.body;
      const  newreg = {
         descripcion
      };

      if (parseInt(tipo_de_submit) <= 0 ) {
            const sql = "INSERT  INTO plantillaconsumo (descripcion,observaciones) values (?,?)";
            const resultado = await pool.query(sql,[ newreg.descripcion, observaciones ]  );
            const exito = await helpers.UpdatedeMateriaprimaPlantilla(tablamateriaprima,[resultado][0].insertId,tabladeeliminados);
            res.redirect('./mostrar-plantillaconsumo');
       }
      else {
           res.redirect('./mostrar-plantillaconsumo');
      }      
   } catch (err) {
      manejo_de_error (err,req,res );
  }
});
//******************************************************* */
router.get('/edit-plantillas/:id', isLoggedIn, async (req,res) => {
   const el_id = req.params.id;
   let sqlf = "";
   try {
      const sql2 = "SELECT id,  descripcion, observaciones FROM plantillaconsumo  Where  id  = ?";
      registro = await pool.query(sql2,el_id);
      const newParam = {
         id_plantilla: el_id ,
         descripcion : registro[0].descripcion,
         observaciones : registro[0].observaciones
      }; 
      sqlf = "SELECT id_plantilla, id_materiaprima, materiaprima.descripcion, materiaprima.unidad, plantillaconsumo_01.cantidad FROM plantillaconsumo_01, materiaprima Where plantillaconsumo_01.id_materiaprima = materiaprima.id and plantillaconsumo_01.id_plantilla = ?" ; 
      const lista_materiaprima = await pool.query (sqlf, [newParam.id_plantilla] );
      const lista = [{ lista_materiaprima },  {newParam} ];
      res.render('links/edit-plantillas',{ lista } );
   } catch (err) {
      manejo_de_error (err,req,res );
   }
  });
//************************************************** */
router.post('/edit-plantillas', async (req, res) => {
   try {
      const { Id_reg , descripcion, tabladeeliminados, tablamateriaprima, observaciones, tipo_de_submit } = req.body;
      const  newreg = {
         el_id : Id_reg,
         descripcion
      };
      if (parseInt(tipo_de_submit) <= 0 ) {
            const sql = "UPDATE plantillaconsumo SET descripcion = ?, observaciones = ?   where id = ? ";
            const resultado = await pool.query(sql,[ newreg.descripcion, observaciones,  newreg.el_id]  );
            const exito = await helpers.UpdatedeMateriaprimaPlantilla(tablamateriaprima,newreg.el_id,tabladeeliminados);
            res.redirect('./mostrar-plantillaconsumo');
       }
      else {
           res.redirect('./mostrar-plantillaconsumo');
      }      
   } catch (err) {
      manejo_de_error (err,req,res );
  }
});

//************************************************** */
//* CRUD deRutas
router.get('/api-listartiposproductos', isLoggedIn, async (req, res) => {
   try {
      const consulta = 'SELECT id_tipo, descripcion, unidad_presentacion FROM tipoproducto';
      const data = await pool.query (consulta);
      res.send(data);
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//***************************************************** */
router.get('/mostrar-crudtipoproductos', async (req, res) => {
   try {
      res.render('links/crud-tipoproductos');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});

//**************************************************** */
router.get('/create-tipoproductos', async function(req, res) {
   try {

      const lista_rutas = await pool.query ("SELECT id_ruta, descripcion FROM rutas" );
      const lista = [{ lista_rutas }];
      res.render('links/create-tipoproductos',{lista});
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//*********************************************************** */
router.post('/create-tipoproductos', async function(req, res) {
   try {
      const { descripcion,   ruta, unidad_presentacion,  tipo_de_submit } = req.body;
      const  newreg = {
         descripcion,
         ruta,
         unidad_presentacion
      };

      if (parseInt(tipo_de_submit) <= 0 ) {
            const sql = "INSERT  INTO tipoproducto (descripcion,id_ruta, unidad_presentacion) values (?,?,?)";
            const resultado = await pool.query(sql,[ newreg.descripcion, newreg.ruta, newreg.unidad_presentacion ]  );
            res.redirect('./mostrar-crudtipoproductos');
       }
      else {
           res.redirect('./mostrar-crudtipoproductos');
      }      

   } catch (err) {
      manejo_de_error (err,req,res );
  }
});
//********************************************** */
router.get('/edit-tipoproductos/:id', isLoggedIn, async (req,res) => {
   try {
      const el_id = req.params.id;
      const sql2 = "SELECT  id_tipo, descripcion, id_ruta, unidad_presentacion  from tipoproducto  Where  id_tipo = ?";
      registro = await pool.query(sql2,parseInt('0' + el_id));
      const newParam = {
         id_tipo: el_id ,
         descripcion : registro[0].descripcion,
         id_ruta : registro[0].id_ruta, 
         unidad_presentacion : registro[0].unidad_presentacion
      }; 
      const lista_rutas = await pool.query ("SELECT id_ruta, descripcion FROM rutas" );
      const lista = [ {newParam}, {lista_rutas} ];
      res.render('links/edit-tipoproductos',{ lista } );
   } catch (err) {
      manejo_de_error (err,req,res );
   }
  });
//******************************************* */
router.post('/edit-tipoproductos', isLoggedIn, async (req,res) => {
   try {
      const { descripcion,   ruta, unidad_presentacion, id_tipo ,  tipo_de_submit } = req.body;
      const  newreg = {
         descripcion,
         ruta,
         unidad_presentacion,
         id_tipo
      };

      if (parseInt(tipo_de_submit) <= 0 ) {
            const sql = "UPDATE tipoproducto set descripcion = ? , id_ruta = ?, unidad_presentacion = ? Where id_tipo = ?";
            const resultado = await pool.query(sql,[ newreg.descripcion, newreg.ruta, newreg.unidad_presentacion, newreg.id_tipo ]  );
            res.redirect('./mostrar-crudtipoproductos');
       }
      else {
            res.redirect('./mostrar-crudtipoproductos');
      }      

   } catch (err) {
      manejo_de_error (err,req,res );
  }


  });
//************************************************* */
//****INICIO DE CRUD DE MAQUINAS */
router.get('/api-listarmaquinas', isLoggedIn, async function(req, res) {
   try {
      const consulta = 'SELECT id_maquina, codigo, descripcion FROM maquinas Where status = "Activa" ';
      const data = await pool.query (consulta);
      res.send(data);
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//************************************ */
router.get('/crud-maquinas', isLoggedIn, async (req,res) => {
   try {
     res.render('links/mant-crudmaquinas');
   } catch (err) {
      manejo_de_error (err,req,res );
  }

});
//****************************************** */

router.get('/create-maquinas', isLoggedIn, async (req,res) => {
   try {
     res.render('links/mant-createmaquinas');
   } catch (err) {
      manejo_de_error (err,req,res );
  }

});
//**************************************************** */
router.post('/create-maquinas', isLoggedIn, async (req,res) => {
   try {
      const {codigo, descripcion,serial,fechacompra, fabricante, proveedor, paginaweb,codigoactivo,funciones ,tipo_de_submit } = req.body;
      const  newreg = {
         codigo,
         descripcion,
         serial,
         fechacompra,
         fabricante,
         proveedor,
         paginaweb,
         codigoactivo,
         funciones,
         user_id: req.user.id
      };
      if(typeof req.file === 'undefined'){
         la_imagen = '';
        }else {
        la_imagen = req.file.filename;
        }
          
      if (parseInt(tipo_de_submit) <= 0 ) {
            const sqlinsert = "INSERT INTO maquinas (codigo,descripcion,serial,fecha_compra , fabricante,proveedor, paginaweb,codigo_del_activo, funcionyusos, imagen) VALUES (?,?,?,?,?,?,?,?,?,?) ";
            const resultado = await pool.query(sqlinsert,[newreg.codigo,newreg.descripcion,newreg.serial, newreg.fechacompra, newreg.fabricante, newreg.proveedor, newreg.paginaweb, newreg.codigoactivo, newreg.funciones,la_imagen ] );

            res.redirect('./crud-maquinas');
      } else {
         res.redirect('./crud-maquinas');

      }
   } catch (err) {
      manejo_de_error (err,req,res );
  }

});
//************************************** */
router.get('/edit-maquinas/:id', isLoggedIn, async (req,res) => {
   const el_id = req.params.id;
   try {
  
      const sql4 = "SELECT   id_maquina,codigo, descripcion, serial ,  DATE_FORMAT(maquinas.fecha_compra, '%Y-%m-%d') AS fecha_compra1   , fabricante, proveedor, paginaweb, codigo_del_activo,funcionyusos, imagen  FROM maquinas  Where  id_maquina = ?";
      const registro = await pool.query(sql4,[el_id] );
    
      const newParam = {
         codigo: registro[0].codigo ,
         descripcion : registro[0].descripcion,
         serial : registro[0].serial,
         fecha_compra : registro[0].fecha_compra1,
         fabricante : registro[0].fabricante,
         proveedor : registro[0].proveedor,
         paginaweb : registro[0].paginaweb,
         codigo_del_activo : registro[0].codigo_del_activo,
         funcionyusos : registro[0].funcionyusos,
         imagen : '/uploads/' +  registro[0].imagen,
         original_img : registro[0].imagen,       
         idreg : el_id,
      };
      //console.log(newParam)
      const lista = [ {newParam} ];
      res.render('links/mant-edit-equipos',{ lista } );

   } catch (err) {
      manejo_de_error (err,req,res );
  }

});
//********************************************************* */
router.post('/edit-maquinas', isLoggedIn, async (req,res) => {
   try {
      let la_imagen = ''; 
      const {codigo, descripcion,serial, imagen1, imagen2, fechacompra, fabricante, proveedor, paginaweb,codigoactivo, id_reg,funciones ,tipo_de_submit } = req.body;
      const  newreg = {
         codigo,
         descripcion,
         serial,
         fechacompra,
         fabricante,
         proveedor,
         paginaweb,
         codigoactivo,
         funciones,
         id_reg,
         user_id: req.user.id,
         
      };
      
      if(typeof req.file === 'undefined'){
         la_imagen = '';
        }else {
        la_imagen = req.file.filename;
        }
          
      if (parseInt(tipo_de_submit) <= 0 ) {

         if (la_imagen.trim().length > 0) {
            var img_original = imagen2 + '';
            if (img_original.trim().length > 0) {
                  var file_to_delete = path.join(__dirname, '..', 'public/uploads/', img_original.trim())
                  if (fs.existsSync(file_to_delete)) {
                     fs.unlinkSync(file_to_delete);  
                  }
            }
           }else {
            la_imagen = imagen2;
           }
            const sqlupdate = "UPDATE maquinas SET codigo = ? , descripcion = ?,   maquinas.serial = ? , fecha_compra = ? , fabricante = ? ,  proveedor = ? ,  paginaweb = ? , codigo_del_activo = ? , funcionyusos =  ? ,  imagen = ?  Where id_maquina = ?";
            const resultado = await pool.query(sqlupdate,[newreg.codigo,newreg.descripcion,newreg.serial, newreg.fechacompra, newreg.fabricante, newreg.proveedor, newreg.paginaweb, newreg.codigoactivo, newreg.funciones,la_imagen, newreg.id_reg  ] );

            res.redirect('./crud-maquinas');
      } else {
         res.redirect('./crud-maquinas');

      }
   } catch (err) {
      manejo_de_error (err,req,res );
  }

});
//******************************************* */
//**CRUD PARA CONTROL DE TRABAJADORES */
router.get('/api-listTrabajadores', isLoggedIn,async function(req, res) {
   try {
      const consulta = 'SELECT trabajadores.id_trabajador , concat_ws(" ", trabajadores.nombre , trabajadores.apellido) as nomb_trabajador , trabajadores.cedula , trabajadores.codigo_nomina, trabajadores.id_cargo, cargos.descripcion as nomb_cargo From  trabajadores, cargos Where trabajadores.id_cargo = cargos.id_cargo ';
      const data = await pool.query (consulta);
      res.send(data);
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});

//***************************************************** */
router.get('/crud-trabajadores', isLoggedIn, async function(req, res) {
   try {
      res.render('links/crud-trabajadores');
   } catch (err) {
      manejo_de_error (err,req,res );
   }
});
//******************************************************* */
router.get('/create-trabajadores', isLoggedIn, async (req,res) => {
   try {

      const lista_cargos = await pool.query("SELECT id_cargo, descripcion FROM cargos order by id_cargo desc");

      const lista = [{lista_cargos}];
      res.render('links/create-trabajadores',{lista});  
        } catch (err) {
          manejo_de_error (err,req,res );                
          }
});
//************************************************************** */
router.post('/create-trabajadores', async (req,res) => {

   try {
      const {fecha_ingreso, tipo_de_submit, codigo, nombres,apellidos, cedula, cargo, status } = req.body;

      const  newreg = {
         fecha_ingreso,
         usuario : req.user.id,
         codigo,
         nombres,
         apellidos,
         cedula,
         cargo,
         status
      };
     
      if (parseInt(tipo_de_submit) <= 0 ) {
         if (newreg.nombres.trim().length > 0) {
            const sql1 = "INSERT INTO trabajadores (codigo_nomina, cedula, nombre,apellido,id_cargo,fecha_ingreso,status ) VALUES (?,?,?,?,?,?,?)";
            const resultado = await pool.query(sql1, [newreg.codigo, newreg.cedula, newreg.nombres,newreg.apellidos, newreg.cargo, newreg.fecha_ingreso, newreg.status] );
         }
         res.redirect('./crud-trabajadores');
       }
      else {
         res.redirect('./crud-trabajadores');
      }      

   } catch (err) {
      manejo_de_error (err,req,res);      
  }


});
//******************************************************* */
router.get('/edit-trabajadores/:id', isLoggedIn, async (req,res) => {  
        try {
            const el_id = helpers.validar_entero(req.params.id);
            const registro =  await pool.query("SELECT   trabajadores.id_trabajador,  trabajadores.codigo_nomina, trabajadores.cedula,  DATE_FORMAT(trabajadores.fecha_ingreso, '%Y-%m-%d') AS fecha_i,  trabajadores.nombre, trabajadores.apellido, trabajadores.id_cargo, trabajadores.status,  cargos.descripcion as nomb_cargo, foto From trabajadores, cargos  Where  trabajadores.id_cargo = cargos.id_cargo and  trabajadores.id_trabajador = ?", el_id);

            const newParam = {
               codigo: registro[0].codigo_nomina,
               cedula : registro[0].cedula,
               fecha_ingreso : registro[0].fecha_i,
               nombres : registro[0].nombre,
               apellidos: registro[0].apellido,
               id_cargo : registro[0].id_cargo,
               nomb_cargo : registro[0].nomb_cargo,
               status : registro[0].status,
               imagen : '/uploads/' +  registro[0].foto,
               originalnameimg : registro[0].foto,      
               idreg : el_id 
            };
            
            const lista_cargos = await pool.query("SELECT id_cargo, descripcion FROM cargos Where id_cargo <> ? order by id_cargo desc", newParam.id_cargo );
            const lista = [{ lista_cargos }, { newParam }];
            res.render('links/edit-trabajadores',{lista});  

         } catch (err) {
               manejo_de_error (err,req,res );         
         }
});
//****************************************************** */
router.post('/edit-trabajadores', async (req,res) => {
   try {
      const {fecha_ingreso, tipo_de_submit, codigo, imagen1,imagen2, nombres,apellidos, cedula, cargo, status, id_reg } = req.body;

      const  newreg = {
         fecha_ingreso,
         usuario : req.user.id,
         codigo,
         nombres,
         apellidos,
         cedula,
         cargo,
         status,
         id_reg
      };

      if(typeof req.file === 'undefined'){
         la_imagen = '';
        }else {
        la_imagen = req.file.filename;
      }
      
      if (parseInt(tipo_de_submit) <= 0 ) {
       //  const parametros = await pool.query('select img_reloj from parametros');
       //  const ruta_to_reloj = parametros[0].img_reloj;
         var img_original = imagen2 + '';
         if (la_imagen.trim().length > 0) {           
            if (img_original.trim().length > 0) {
                  var file_to_delete = path.join(__dirname, '..', 'public/uploads/', img_original.trim())
                  if (fs.existsSync(file_to_delete)) {
                     fs.unlinkSync(file_to_delete);  
                  }
            }
           }else {   
                  la_imagen = imagen2;           
           }

      //   if (la_imagen.trim().length > 0 )     {

          //  var file_to_copy = path.join(__dirname, '..', 'public/uploads/', la_imagen);
          //  if (fs.existsSync(file_to_copy)) {
           //    fs.copyFileSync(file_to_copy,ruta_to_reloj + la_imagen)                     
         //   }
            
       //  }

         if (newreg.nombres.trim().length > 0) {
            const sql1 = "UPDATE trabajadores SET codigo_nomina = ? , cedula = ? , nombre = ? ,apellido = ? ,id_cargo = ? ,fecha_ingreso = ? ,status = ?, foto = ?  Where id_trabajador = ? ";
            const resultado = await pool.query(sql1, [newreg.codigo, newreg.cedula, newreg.nombres,newreg.apellidos, newreg.cargo, newreg.fecha_ingreso, newreg.status, la_imagen.trim(), newreg.id_reg] );
         }
          res.redirect('./crud-trabajadores');
       }
      else {
         res.redirect('./crud-trabajadores');
      }      

   } catch (err) {
      manejo_de_error (err,req,res);      
  }


});


//****************************************************** */

module.exports = router;


function  manejo_de_error (err, req, res)  {
   var usuario = '  Usuario : ' +  req.user.fullname;
   rollbar.error(err.stack + usuario);
   console.log(err);
   const  newerr = {
      mensaje : 'Ocurrio un error interno en la Aplicación',
      user_id: req.user.id,
      mensaje2 : err.stack
   };
   const el_error = [{newerr}];
   res.render('links/errorpage',{ el_error });
}
